#pragma once
#include "../acl_cpp_define.hpp"
#include "redis_command.hpp"

#if !defined(ACL_CLIENT_ONLY) && !defined(ACL_REDIS_DISABLE)

namespace acl
{

class redis_client;

/**
 * redis Connection ࣬£
 * AUTHECHOPINGQUITSELECT
 * redis connection command clss, including as below:
 * AUTH, ECHO, PING, QUIT, SELECT
 */
class ACL_CPP_API redis_connection : virtual public redis_command
{
public:
	/**
	 * see redis_command::redis_command()
	 */
	redis_connection(void);

	/**
	 * see redis_command::redis_command(redis_client*)
	 */
	redis_connection(redis_client* conn);

	/**
	 * see redis_command::redis_command(redis_client_cluster*)
	 */
	redis_connection(redis_client_cluster* cluster);

	ACL_CPP_DEPRECATED
	redis_connection(redis_client_cluster* cluster, size_t max_conns);

	virtual ~redis_connection(void);

	/////////////////////////////////////////////////////////////////////

	/**
	 *  redis-server ʱ֤
	 * AUTH command to login the redis server.
	 * @param passwd {const char*}  redis ļָ֤
	 *  the password in redis-server configure
	 * @return {bool} ֤Ƿɹ false ʾ֤ʧܻʧ
	 *  return true if success, or false because auth failed or error.
	 */
	bool auth(const char* passwd);

	/**
	 * ѡ redis-server еݿ ID
	 * SELECT command to select the DB id in redis-server
	 * @param dbnum {int} redis ݿ ID
	 *  the DB id
	 * @return {bool} Ƿɹ
	 *  return true if success, or false for failed.
	 */
	bool select(int dbnum);

	/**
	 * ̽ redis Ƿ
	 * PING command for testing if the connection is OK
	 * @return {bool} Ƿ
	 *  return true if success
	 */
	bool ping();

	/**
	 *  redis-server Ըַ
	 * ECHO command, request redis-server to echo something.
	 * @return {bool} Ƿɹ
	 *  return true if success
	 */
	bool echo(const char* s);

	/**
	 * ر redis 
	 * QUIT command to close the redis connection
	 * @return {bool}
	 *  return true if success
	 */
	bool quit();
};

} // namespace acl

#endif // !defined(ACL_CLIENT_ONLY) && !defined(ACL_REDIS_DISABLE)
