#pragma once
#include "../acl_cpp_define.hpp"
#include "session.hpp"

#ifndef ACL_CLIENT_ONLY

namespace acl {

class memcache;

/**
 * session ࣬ʹ memcached 洢 session 
 */
class ACL_CPP_API memcache_session : public session
{
public:
	/**
	 * 캯
	 * @param cache_addr {const char*} memcached ַʽ
	 *  IP:PORTΪ
	 * @param prefix {const char*}  memcached 洢ļֵǰ׺
	 * @param conn_timeout {int}  memcached ĳʱʱ()
	 * @param rw_timeout {int}  memcached ͨѶ IO ʱʱ()
	 * @param ttl {time_t} ()
	 * @param sid {const char*} session Ӧ sidΪʱڲ
	 *  Զһ˵ο session ˵
	 * @param encode_key {bool} ǷԴ洢 memcached ļֵб
	 */
	memcache_session(const char* cache_addr, int conn_timeout = 180,
		int rw_timeout = 300, const char* prefix = NULL,
		time_t ttl = 0, const char* sid = NULL, bool encode_key = true);

	/**
	 *  memcached ӶΪĹ캯
	 * @param cache {memcache*}  memcached Ӷ
	 * @param auto_free {bool} òΪ true ʱҪ
	 *  memcached_session ͷŴ cache 
	 *  ֹ memcached_session ͷ cache 
	 * @param ttl {time_t} ()
	 * @param sid {const char*} session Ӧ sidΪʱڲ
	 *  Զһ˵ο session ˵
	 */
	memcache_session(memcache* cache, bool auto_free = false,
		time_t ttl = 0, const char* sid = NULL);

	~memcache_session(void);

	// ി麯 memcached л
	bool get_attrs(std::map<string, session_string>& attrs);

	// ി麯 memcached ӻ޸
	bool set_attrs(const std::map<string, session_string>& attrs);

	// ി麯 memcached ɾ
	bool remove();

protected:
	// session  memcached ϵĻʱ
	bool set_timeout(time_t ttl);

private:
	memcache* cache_;
	bool auto_free_;
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
