#pragma once
#include "../acl_cpp_define.hpp"
#include <map>
#include "../stdlib/dbuf_pool.hpp"
#include "../stdlib/string.hpp"

#ifndef ACL_CLIENT_ONLY

namespace acl {

// 洢ֵĻ壬ҪΪ˼ֵ
// ΪƵζӵĽṹ
typedef enum
{
	TODO_NUL,
	TODO_SET,
	TODO_DEL
} todo_t;

class ACL_CPP_API session_string : public string
{
public:
	session_string(size_t n = 64) : string(n), todo_(TODO_NUL) {}
	session_string(const session_string& ss)
		: string(ss)
	{
		todo_ = ss.todo_;
	}
	session_string(const string& s) : string(s), todo_(TODO_NUL) {}
	session_string(const char* s) : string(s), todo_(TODO_NUL) {}
	~session_string() {}
	todo_t todo_;
};

/**
 * session ࣬ʹ memcached 洢 session 
 */
class ACL_CPP_API session : public dbuf_obj
{
public:
	/**
	 * 캯Ĳ sid ǿʱ session ʹø
	 * sidڲԶһ sidûӦͨ get_sid()
	 * Զɵ sid Աÿβѯ sid Ӧ
	 * @param ttl {time_t} ָ session ()
	 * @param sid {const char*} ǿʱ session  sid ʹ
	 *  ֵڲһ session sid
	 *  sid ͨ get_sid() ãȻʹùУû
	 *  Ҳͨ set_sid() ޸ı session sid
	 *  ⣬ sid Ϊգûĳ sid Ӧ
	 *  ݣûȵ set_sid()
	 */
	session(time_t ttl = 0, const char* sid = NULL);
	virtual ~session(void);
	
	/**
	 * ڲ״̬һЩʱ
	 */
	void reset(void);

	/**
	 * ñ session Ψһ ID ʶ
	 * @return {const char*} ǿ
	 */
	virtual const char* get_sid(void) const
	{
		return sid_.c_str();
	}

	/**
	 * ñ session Ψһ ID ʶ
	 * @param sid {const char*} ǿ
	 * עñ󣬻Զ֮ǰм仺
	 */
	void set_sid(const char* sid);

	/**
	 *  session  set/set_ttl ʱһ delay Ϊ true
	 * ͨñи
	 * @return {bool} ݸǷɹ
	 */
	virtual bool flush();

	/**
	 *  session µַԣͬʱø
	 * session Ĺʱ()
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @return {bool}  false ʾ
	 */
	virtual bool set(const char* name, const char* value);

	/**
	 *  session µԶø session Ĺʱ()
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @param len {size_t} value ֵ
	 * @return {bool}  false ʾ
	 */
	virtual bool set(const char* name, const void* value, size_t len);

	/**
	 * ӳ session µԶø session Ĺʱ()
	 * û session::flush ٽݸ£ ߴЧ
	 * @param name {const char*} session ǿ
	 * @param value {const char*} session ֵǿ
	 * @param len {size_t} value ֵ
	 * @return {bool}  false ʾ
	 */
	virtual bool set_delay(const char* name, const void* value, size_t len);
	
	/**
	 *  session ȡֵַ
	 * @param name {const char*} session ǿ
	 * @return {const char*} session ֵصַָԶǿգû
	 *  ͨжϷصǷǿմ(: "\0")жϳ򲻴
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	const char* get(const char* name);

	/**
	 *  session ȡö͵ֵ
	 * @param name {const char*} session ǿ
	 * @return {const session_string*} session ֵؿʱ
	 *  ʾ򲻴
	 *  עúطǿݺûӦ̱˷ֵΪ´
	 *      ÿܻʱ
	 */
	virtual const session_string* get_buf(const char* name);

	/**
	 *  session ɾֵָеıɾ
	 * ʱὫ memcached ɾ
	 * @param name {const char*} session ǿ
	 * @return {bool} true ʾɹ()false ʾɾʧ
	 *  עӳٷʽɾĳʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣ̸
	 */
	virtual bool del_delay(const char* name);
	virtual bool del(const char* name);

	/**
	 *  session ڻϵĻʱ
	 * @param ttl {time_t} ()
	 * @param delay {bool} Ϊ true ʱӳٷ͸ָ˵
	 *  û session::flush ٽݸ£
	 *  ߴЧʣΪ false ʱ̸
	 * @return {bool} Ƿɹ
	 */
	bool set_ttl(time_t ttl, bool delay);

	/**
	 * ñ session м¼ session ڣֵп
	 * 洢ڻʱ䲻һ£Ϊпʵ
	 *  session ڻϵ
	 * @return {time_t}
	 */
	time_t get_ttl(void) const
	{
		return ttl_;
	}

	/**
	 * ʹ session ӷ˵Ļɾʹ session ʧЧ
	 * @return {bool} Ƿʹ session ʧЧ
	 */
	virtual bool remove(void) = 0;

	/**
	 * Ӻ˻лöӦ sid Զ󼯺
	 * @param attrs {std::map<string, session_string>&}
	 * @return {bool}
	 */
	virtual bool get_attrs(std::map<string, session_string>& attrs) = 0;

	/**
	 * Ӻ˻лöӦ sid ָԼ
	 * @param names {const std::vector<string>&} 
	 * @param values {std::vector<session_string>&} 洢Ӧֵ
	 * @return {bool} Ƿɹ
	 */
	virtual bool get_attrs(const std::vector<string>& names,
		std::vector<session_string>& values);

	/**
	 * ˻дӦ sid Զ󼯺
	 * @param attrs {std::map<string, session_string>&}
	 * @return {bool}
	 */
	virtual bool set_attrs(const std::map<string, session_string>& attrs) = 0;

protected:
	// öӦ sid ݵĹʱ
	virtual bool set_timeout(time_t ttl) = 0;

protected:
	//  session л
	static void serialize(const std::map<string, session_string>& attrs,
		string& out);

	//  session ݷл
	static void deserialize(string& buf,
		std::map<string, session_string>& attrs);

	//  session Լ
	static void attrs_clear(std::map<string, session_string>& attrs);

protected:
	session_string sid_;
	time_t ttl_;

	// ñҪ set_ttl УƲ sid_ ֻ²
	// һûں cache ˴洢 set_ttl º
	//  cache 
	bool sid_saved_;
	bool dirty_;
	std::map<string, session_string> attrs_;
	std::map<string, session_string> attrs_cache_;
};

} // namespace acl

#endif // ACL_CLIENT_ONLY
