#pragma once
#include "../acl_cpp_define.hpp"
#include <vector>
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"
#include "../http/http_ctype.hpp"

#if !defined(ACL_MIME_DISABLE)

namespace acl {

class mime_code;
class mail_attach;

/**
 * ʼĹ
 */
class ACL_CPP_API mail_body : public noncopyable
{
public:
	/**
	 * 캯
	 * @param charset {const char*} ĵַ
	 * @param encoding {const char*} ĵıʽ
	 */
	mail_body(const char* charset = "utf-8",
		const char* encoding = "base64");
	~mail_body();

	/**
	 * 
	 * @return {const string&}
	 */
	const string& get_content_type() const
	{
		return content_type_;
	}

	/**
	 * Ͷ
	 * @return {const http_ctype&}
	 */
	const http_ctype& get_ctype() const
	{
		return ctype_;
	}

	/**
	 * ʼΪ TEXT/HTML ʽ
	 * @param html {const char*} HTML 
	 * @param len {size_t} html ݳ(Ȼ html ַʽṩ
	 *  ݳڵøЧڲͨ strlen 㳤)
	 * @return {mail_body&}
	 */
	mail_body& set_html(const char* html, size_t len);

	/**
	 * ʼΪ TEXT/PLAIN ʽ
	 * @param plain {const char*} TEXT 
	 * @param len {size_t} plain ݳ(Ȼ plain ıʽṩ
	 *  ݳڵøЧڲͨ strlen 㳤)
	 * @return {mail_body&}
	 */
	mail_body& set_plain(const char* plain, size_t len);

	/**
	 * ʼΪ multipart/alternative ʽʱô˺Ӧ͵
	 * 
	 * @param html {const char*} е HTML (ǿ)
	 * @param hlen {size_t} html ݳ(>0)
	 * @param plain {const char*} е TEXT (ǿ)
	 * @param plen {size_t} plain ݳ(>0)
	 * @return {mail_body&}
	 */
	mail_body& set_alternative(const char* html, size_t hlen,
		const char* plain, size_t plen);

	/**
	 * ʼΪ multipart/relative ʽʱô˺
	 * @param html {const char*} е HTML (ǿ)
	 * @param hlen {size_t} html ݳ(>0)
	 * @param plain {const char*} е plain (ǿ)
	 * @param plen {size_t} plain ݳ(>0)
	 * @param attachments {const std::vector<mail_attach*>&} 
	 *   html е cid صͼƬȸ
	 * @return {mail_body&}
	 */
	mail_body& set_relative(const char* html, size_t hlen,
		const char* plain, size_t plen,
		const std::vector<mail_attach*>& attachments);

	/**
	 *  set_html õ html/plain 
	 * @param len {size_t} ݳȽ
	 * @return {const char*}
	 */
	const char* get_html(size_t& len) const
	{
		len = hlen_;
		return html_;
	}

	/**
	 *  set_plain õ plain/plain 
	 * @param len {size_t} ݳȽ
	 * @return {const char*}
	 */
	const char* get_plain(size_t& len) const
	{
		len = plen_;
		return plain_;
	}

	/**
	 *  set_attachments õĸ
	 * @return {const std::vector<mail_attach*>*}
	 */
	const std::vector<mail_attach*>* get_attachments() const
	{
		return attachments_;
	}

	/**
	 * ʼĲ׷ڸ
	 * @param out {ostream&} 
	 * @return {bool} Ƿɹ
	 */
	bool save_to(ostream& out) const;

	/**
	 * ʼĲ׷ڸĻ
	 * @param out {string&} 洢
	 * @return {bool} Ƿɹ
	 */
	bool save_to(string& out) const;

	/**
	 * text/html ʽʼḶ́׷ڸĻ
	 * @param in {const char*}  html ʽ
	 * @param len {size_t} in ݳ
	 * @param out {string&} ׷ӷʽ洢
	 * @return {bool} Ƿɹ
	 */
	bool save_html(const char* in, size_t len, string& out) const;

	/**
	 * text/plain ʽʼḶ́׷ڸĻ
	 * @param in {const char*}  plain ʽ
	 * @param len {size_t} in ݳ
	 * @param out {string&} ׷ӷʽ洢
	 * @return {bool} Ƿɹ
	 */
	bool save_plain(const char* in, size_t len, string& out) const;

	/**
	 * multipart/relative ʽʼḶ́׷ڸĻ
	 * @param html {const char*}  html ʽ
	 * @param hlen {size_t} html ݳ
	 * @param plain {const char*} е TEXT (ǿ)
	 * @param plen {size_t} plain ݳ(>0)
	 * @param attachments {const std::vector<mail_attach*>&} 
	 *   html е cid صͼƬȸ
	 * @param out {string&} ׷ӷʽ洢
	 * @return {bool} Ƿɹ
	 */
	bool save_relative(const char* html, size_t hlen,
		const char* plain, size_t plen,
		const std::vector<mail_attach*>& attachments,
		string& out) const;

	/**
	 * multipart/alternative ʽʼḶ́׷ڸĻ
	 * @param html {const char*}  html ʽ
	 * @param hlen {size_t} html ݳ
	 * @param plain {const char*} е TEXT (ǿ)
	 * @param plen {size_t} plain ݳ(>0)
	 * @param out {string&} ׷ӷʽ洢
	 * @return {bool} Ƿɹ
	 */
	bool save_alternative(const char* html, size_t hlen,
		const char* plain, size_t plen, string& out) const;

private:
	string  charset_;
	string  content_type_;
	string  transfer_encoding_;
	mime_code* coder_;
	string  boundary_;
	http_ctype ctype_;
	int     mime_stype_;

	const char* html_;
	size_t hlen_;
	const char* plain_;
	size_t plen_;
	const std::vector<mail_attach*>* attachments_;

	bool build(const char* in, size_t len, const char* content_type,
		const char* charset, mime_code& coder, string& out) const;
	bool build_html(const char* in, size_t len,
		const char* charset, string& out) const;
	bool build_plain(const char* in, size_t len,
		const char* charset, string& out) const;

	void set_content_type(const char* content_type);
};

} // namespace acl

#endif // !defined(ACL_MIME_DISABLE)
