#pragma once
#include "../acl_cpp_define.hpp"

#include "string.hpp"
#include "pipe_stream.hpp"

struct ACL_VSTRING;

namespace acl {

class ACL_CPP_API charset_conv : public pipe_stream
{
public:
	charset_conv(void);
	~charset_conv(void);

	/**
	 * ǷЧֱַӿ
	 * @param onoff {bool} Ϊ true ʱת
	 *  ǷֱַӿĬֱӿ
	 */
	void set_add_invalid(bool onoff);

	/**
	 * ת
	 * @param fromCharset {const char*} Դַ
	 * @param toCharset {const char*} Ŀַ
	 * @param in {const char*} Դݵַ(ǿ)
	 * @param n {size_t} Դݵĳ(>0)
	 * @param out {string*} 洢ת
	 * @return {bool} תǷɹ
	 */
	bool convert(const char* fromCharset, const char* toCharset,
		const char* in, size_t n, string* out);

	/**
	 * תʧ, úسԭ
	 * @return {const char*} ԭ
	 */
	const char* serror(void) const;

	/**
	 * ת״̬, ýظʹ, ٴʹǰҪ
	 * set(from, to) ԴַĿַ
	 */
	void reset(void);

	/* ʽ̣update_begin->update->update ... ->update_finish */

	/**
	 * ʼʽز
	 * @param fromCharset {const char*} Դַ
	 * @param toCharset {const char*} Ŀַ
	 * @return {bool} ʼǷɹ
	 */
	bool update_begin(const char* fromCharset, const char* toCharset);

	/**
	 * ʽʽַת
	 * @param in {const char*} Դַ
	 * @param len {size_t} in ַ
	 * @param out {string*} 洢ת
	 * @return {bool} ǰתǷɹ
	 */
	bool update(const char* in, size_t len, string* out);

	/**
	 * ʽתҪô˺ȡת
	 * @param out {string*} 洢ת
	 */
	void update_finish(string* out);

	/**
	 * ַת
	 * @param fromCharset {const char*} Դַ
	 * @param toCharset {const char*} Ŀַ
	 * @return {charset_conv*} ǷԴַ
	 *  Ŀַַ֧ͬת򷵻NULL
	 *  Ҫ delete ɾ
	 */
	static charset_conv* create(const char* fromCharset,
	                const char* toCharset);

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear();

private:
	bool m_addInvalid;  // ЧַǷֱӿ
	string  m_errmsg;
	string* m_pBuf;
	char  m_fromCharset[32];
	char  m_toCharset[32];
	void* m_iconv;
	ACL_VSTRING* m_pInBuf;
	ACL_VSTRING* m_pOutBuf;
	const char* m_pUtf8Pre;
};

} // namespace acl
