#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include <vector>
#include "noncopyable.hpp"

namespace acl
{

class diff_object;

/**
 * ϵĲĹ
 */
class diff_manager : public noncopyable
{
public:
	diff_manager(long long range_from = -1, long long range_to = -1);
	~diff_manager(void);

	/**
	 * ڲڴض
	 * @return {dbuf_guard&} ڽڴضʹøڴش
	 *   diff_manager ǰ٣Ϊ diff_manager ʱ
	 *  ڽڴػԶ
	 */
	dbuf_guard& get_dbuf(void);

	/**
	 * ȽϵĲӶĶ󼯺ϡɾĶ󼯺
	 * Լ仯Ķ󼯺
	 * @param curr_objs {const std::vector<diff_object*>&} ǰļ
	 * @param old_olds {const std::list<diff_object*>&} Ԫؼϣڲ
	 *  øüɹϣʹǰþɼϽв컯Ƚ
	 */
	void diff_changes(const std::vector<diff_object*>& curr_objs,
		const std::vector<diff_object*>& old_olds);

	/**
	 * Ķ󼯺
	 * @return {std::vector<diff_object*>&}
	 */
	const std::vector<diff_object*>& get_new(void) const
	{
		return objs_new_;
	}

	/**
	 *  diff_changes в컯Ƚϳɹ󣬱ڷھɼϣ
	 * ڵǰвڵģɾģԪؼ
	 * @return {std::vector<diff_object*>&}
	 */
	const std::vector<diff_object*>& get_deleted(void) const
	{
		return objs_del_;
	}

	/**
	 *  diff_changes в컯Ƚϳɹ󣬱ڷھɼϣ
	 * ڵǰжֵ仯ı仯϶
	 * @return {std::vector<std::pair<diff_object*, diff_object*> >&}
	 *  ز仯Ķļϣ pair е first Ϊ¶second
	 *  Ϊɶ
	 * @sample
	 *  const std::vector<std::pair<diff_object*, diff_object*> >&
	 *  	results = manager.get_updated();
	 *  std::vector<std::pair<diff_object*, diff_object*> >::const_iterator
	 *  	cit = results.begin();
	 *  for (; cit != results.end(); ++cit)
	 *  	printf(">> key: %s, curr value:%s, old value: %s\r\n",
	 *  		(*cit).first->get_key(),
	 *  		(*cit).first->get_val(),
	 *  		(*cit).second->get_val());
	 */
	const std::vector<std::pair<diff_object*, diff_object*> >&
		get_updated(void) const
	{
		return objs_upd_;
	}

	/**
	 *  diff_manger в컪Ƚϳɹ󣬱ڷͬļ
	 * @return {std::vector<diff_object*>&}
	 */
	const std::vector<diff_object*>& get_same(void) const
	{
		return objs_equ_;
	}

	/**
	 * Ĳָ䷶ΧڵĶ󼯺
	 * @return {const std::vector<diff_object*>&}
	 */
	const std::vector<diff_object*>& get_extra_added(void) const
	{
		return objs_new_extra_;
	}

	/**
	 * ɾĲָ䷶ΧڵĶ󼯺
	 * @return {const std::vector<diff_object*>&}
	 */
	const std::vector<diff_object*>& get_extra_deleted(void) const
	{
		return objs_del_extra_;
	}

	/**
	 * ޸ĵĲָ䷶ΧڵĶ󼯺
	 * @return {const std::vector<diff_object*>&}
	 */
	const std::vector<std::pair<diff_object*, diff_object*> >&
		get_extra_updated(void) const
	{
		return objs_upd_extra_;
	}

	/**
	 * ظʹñ diff_manager в컯ȽʱҪñ
	 * һαȽϹвʱڴ漰
	 */
	void reset(void);

private:
	dbuf_guard dbuf_;
	long long  range_from_;
	long long  range_to_;

	// ͬĶ󼯺
	std::vector<diff_object*> objs_equ_;

	// 仯Ķ󼯺

	// Ķ󼯺
	std::vector<diff_object*> objs_new_;
	// ɾĶ󼯺
	std::vector<diff_object*> objs_del_;
	// ޸ĵĶ󼯺
	std::vector<std::pair<diff_object*, diff_object*> > objs_upd_;

	// Ķ󼯺

	// Ķ󼯺
	std::vector<diff_object*> objs_new_extra_;
	// ɾĶ󼯺
	std::vector<diff_object*> objs_del_extra_;
	// ޸ĵĶ󼯺
	std::vector<std::pair<diff_object*, diff_object*> > objs_upd_extra_;
};

} // namespace acl
