#pragma once
#include "../acl_cpp_define.hpp"
#include "dbuf_pool.hpp"

namespace acl
{

class diff_manager;

/**
 * Ƚϴ̳࣬и࣬ʵеĴ鷽
 * ̳ dbuf_obj ࣬ dbuf_guard ͳһͳһ
 */
class diff_object : public dbuf_obj
{
public:
	/**
	 * 캯
	 * @param manager {diff_manager&}
	 */
	diff_object(diff_manager& manager);

	virtual ~diff_object(void) {}

	/**
	 * ӿڣøöļַ
	 * @return {const char*} 뷵طǿַ
	 */
	virtual const char* get_key(void) const = 0;

	/**
	 * ӿڣøöֵַ
	 * @return {const char*} 뷵طǿַ
	 */
	virtual const char* get_val(void) const = 0;

	/**
	 * ӿڣȽ
	 * @param obj {const diff_object&}
	 * @return {bool} Ƿ
	 */
	virtual bool operator== (const diff_object& obj) const = 0;

	/**
	 * Ƿǲڸ䷶Χ䣩Ķ
	 * @param range_from {long long} ʼλ
	 * @param range_to {long long} λ
	 * @return {bool} Ƿǳ䷶ΧĶݶ
	 */
	virtual bool check_range(long long range_from, long long range_to) const
	{
		(void) range_from;
		(void) range_to;
		return false;
	}

protected:
	diff_manager& manager_;
};

} // namespace acl
