#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include "../ipc/ipc_service.hpp"
#include "../stream/aio_handle.hpp"
#include "../stream/aio_delay_free.hpp"
#include "string.hpp"

namespace acl
{

class ACL_CPP_API dns_res
{
public:
	dns_res(const char* domain) : domain_(domain) {}
	~dns_res() { ips_.clear(); }

	string domain_;
	std::list<string> ips_;
protected:
private:
};

class ACL_CPP_API dns_result_callback
{
public:
	dns_result_callback(const char* domain) : domain_(domain) {}

	/**
	 * ϻʱڲ̻Զ destroy ӿڣ
	 * ڸýӿڽһЩͷẒ́䵱öǶ̬ʱ
	 * Ӧڸú delete this ɾԼΪúտ϶
	 * ᱻã಻Ӧط
	 */
	virtual void destroy(void) {}

	/**
	 * ʵִ˽ӿڣԻòѯ res.ips_.size() == 0
	 * ˵ѯΪ
	 * @param domain {const char*} ûĲѯ
	 * @param res {const dns_res&} ѯ
	 *  עڸûصвɾ dns_service 󣬷򽫻
	 *      ڴǷʣΪûص dns_service бõģ
	 *      ڸúغ dns_service 󻹻ʹ
	 */
	virtual void on_result(const char* domain, const dns_res& res) = 0;

	/**
	 * ڹ캯õֵ
	 */
	const string& get_domain() const { return (domain_); }
protected:
	virtual ~dns_result_callback() {}
private:
	string domain_;
};

class ipc_client;

class ACL_CPP_API dns_service
	: public ipc_service
	, public aio_delay_free
{
public:
	/**
	 * 캯
	 * @param nthread {int} ֵ > 1 ڲԶ̳߳أ
	 *  һһ߳
	 * @param win32_gui {bool} ǷǴϢǣڲ
	 *  ͨѶģʽԶΪ _WIN32 ϢȻͨõ׽
	 *  ͨѶʽ
	 */
	dns_service(int nthread = 1, bool win32_gui = false);
	~dns_service();

	/**
	 * ʼ
	 * @param callback {dns_result_callback*} Ϻص
	 *  Ļص on_result
	 */
	void lookup(dns_result_callback* callback);

	/**
	 * ѯ̵֪߳ͨ߳Ĳѯ󣬸òѯ
	 * ñص֪ͨѯ
	 * @param res {const dns_res&} ѯ
	 */
	void on_result(const dns_res& res);
protected:
	/**
	 * 麯ӵʱص˺
	 * @param client {aio_socket_stream*} յµĿͻ
	 */
	virtual void on_accept(aio_socket_stream* client);

#if defined(_WIN32) || defined(_WIN64)
	/**
	 * 麯յ̵߳ win32 ϢʱĻص
	 * @param hWnd {HWND} ھ
	 * @param msg {UINT} ûԶϢ
	 * @param wParam {WPARAM} 
	 * @param lParam {LPARAM} 
	 */
	virtual void win32_proc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
#endif
private:
	std::list<dns_result_callback*> callbacks_;
};

}
