#pragma once
#include "../acl_cpp_define.hpp"
#include <assert.h>
#include "noncopyable.hpp"

namespace acl
{

// internal functions being used
void*  mbox_create(void);
void   mbox_free(void*, void (*free_fn)(void*));
bool   mbox_send(void*, void*);
void*  mbox_read(void*, int, bool*);
size_t mbox_nsend(void*);
size_t mbox_nread(void*);

/**
 * ֮߳䡢Э֮ͨŵ࣬ڲʵֲ + IO ͨ
 * Ϸʽʵ
 *
 * ʾ:
 *
 * class myobj
 * {
 * public:
 *     myobj(void) {}
 *     ~myobj(void) {}
 *     
 *     void run(void)
 *     {
 *         printf("hello world!\r\n");
 *     }
 * };
 * 
 * acl::mbox<myobj> mbox;
 *
 * void thread_producer(void)
 * {
 *     myobj* o = new myobj;
 *     mbox.push(o);
 * }
 * 
 * void thread_consumer(void)
 * {
 *     myobj* o = mbox.pop();
 *     o->run();
 *     delete o;
 * }
 */

template<typename T>
class mbox : public noncopyable
{
public:
	/**
	 * 췽
	 * @param free_obj {bool}  tbox ʱǷԶ鲢ͷ
	 *  δѵĶ̬
	 */
	mbox(bool free_obj = true)
	: free_obj_(free_obj)
	{
		mbox_ = mbox_create();
		assert(mbox_);
	}

	~mbox(void)
	{
		mbox_free(mbox_, free_obj_ ? mbox_free_fn : NULL);
	}

	/**
	 * Ϣ
	 * @param t {T*} ǿϢ
	 * @return {bool} Ƿɹ
	 */
	bool push(T* t)
	{
		return mbox_send(mbox_, t);
	}

	/**
	 * Ϣ
	 * @param timeout {int} >= 0 ʱöȴʱʱ(뼶)
	 *  ԶȴֱϢ
	 * @param success {bool*} ڸȷǷɹ
	 * @return {T*}  NULL ʾһϢΪ NULL ʱͨ
	 *  success ķֵǷɹ
	 */
	T* pop(int timeout = -1, bool* success = NULL)
	{
		return (T*) mbox_read(mbox_, timeout, success);
	}

	/**
	 * ͳƵǰѾ͵Ϣ
	 * @return {size_t}
	 */
	size_t push_count(void) const
	{
		return mbox_nsend(mbox_);
	}

	/**
	 * ͳƵǰѾյϢ
	 * @return {size_t}
	 */
	size_t pop_count(void) const
	{
		return mbox_nread(mbox_);
	}

private:
	void* mbox_;
	bool  free_obj_;

	static void mbox_free_fn(void* o)
	{
		T* t = (T*) o;
		delete t;
	}
};

} // namespace acl
