#pragma once
#include "../acl_cpp_define.hpp"
#include "noncopyable.hpp"

namespace acl
{

/**
 * 麯߳࣬ʵ run ߳бִе
 */
class ACL_CPP_API thread_job : public noncopyable
{
public:
	thread_job(void) {}
	virtual ~thread_job(void) {}

	/**
	 * 麯ʵִ˺úִ߳
	 * @return {void*} ߳˳ǰصĲ
	 */
	virtual void* run(void) = 0;

	/**
	 * 鷽´߳е run() ǰãͬ
	 * ̷߳ʽ£̱߳ø鷽Ȼ֪̣ͨ߳
	 * Ӷ֤ڴ̵߳ start() ǰִ߳гʼ̡
	 */
	virtual void init(void) {}
};

template<typename T> class tbox;
class atomic_long;

/**
 * ̴߳࣬Ľӿڶ Java Ľӿڶ壬Ҫʵ
 * Ĵ麯ʹͨ thread::start() ̹߳
 */
class ACL_CPP_API thread : public thread_job
{
public:
	thread(void);
	virtual ~thread(void);

	/**
	 * ʼ̹̣߳һúãһµ
	 * ִ̣߳߳л thread_job::run 
	 * @return {bool} Ƿɹ߳
	 */
	bool start(bool sync = false);

	/**
	 * ߳ʱΪ detachable ״̬ô˺ȴ߳̽
	 * ߳ʱΪ detachable ״̬ʱֹñ
	 * @param out {void**} òǿָʱò
	 *  ߳˳ǰصĲ
	 * @return {bool} Ƿɹ
	 */
	bool wait(void** out = NULL);

	/**
	 * ڵ start ǰô˺߳ǷΪ (detachable)
	 * ״̬δô˺߳ĬΪǷ״̬ڷǷ״
	 * ̬£߳̿ wait ̶߳󣬷ֹ wait ̶߳ڷ
	 * ״̬£̱߳Ҫ wait ̣߳ڴй¶
	 * @param yes {bool} ǷΪ״̬
	 * @return {thread&}
	 */
	thread& set_detachable(bool yes);

	/**
	 * ڵ start ǰô˺̵߳ĶջС
	 * @param size {size_t} ̶߳ջСֵΪ 0 δ
	 *  ô˺̶߳ջСΪϵͳĬֵ
	 * @return {thread&}
	 */
	thread& set_stacksize(size_t size);

	/**
	 * ڵ start ô˺Ի̵߳ id 
	 * @return {unsigned long}
	 */
	unsigned long thread_id(void) const;

	/**
	 * ǰ̵߳߳ id 
	 * @return {unsigned long}
	 */
	static unsigned long thread_self(void);
	static unsigned long self(void)
	{
		return thread_self();
	}

private:
	bool detachable_;
	size_t stack_size_;
#if defined(_WIN32) || defined(_WIN64)
	void* thread_;
	unsigned long thread_id_;
#else
	pthread_t thread_;
	unsigned long thread_id_;
#endif
	tbox<int>*   sync_;
	atomic_long* lock_;

	void* return_arg_;
	static void* thread_run(void* arg);

	void wait_for_running(void);
};

} // namespace acl
