#pragma once
#include "../acl_cpp_define.hpp"
#include "noncopyable.hpp"

#if !defined(_WIN32) && !defined(_WIN64)
# include <pthread.h>
# ifndef	acl_pthread_cond_t
#  define	acl_pthread_cond_t	pthread_cond_t
# endif
#else
struct acl_pthread_cond_t;
#endif

namespace acl {

class thread_mutex;

/**
 * ߳
 */
class ACL_CPP_API thread_cond : public noncopyable
{
public:
	/**
	 * 췽
	 * @param mutex {thread_mutex*} ò NULL ʱڲԶ
	 *  ߳ڲ߳
	 */
	thread_cond(thread_mutex* mutex = NULL);
	~thread_cond(void);

	/**
	 * ȴ߳
	 * @param microseconds {long long} ȴĳʱʱ(΢뼶)
	 *   > 0 ʱʾȴʱʱ
	 *   == 0ȴ
	 *   < 0 һֱȴֱ
	 * @param locked {bool} òǷѾδ
	 *  ڲԶǰٽⲿѾڲ
	 *  /
	 * @return {bool}  true ʾʾʱû֪ͨ
	 */
	bool wait(long long microseconds = -1, bool locked = false);

	/**
	 * ֪ͨһ򼸸ȴ߳ϵ̣߳ʾͽ
	 * @return {bool}  false ʾ֪ͨʧ
	 */
	bool notify(void);

	/**
	 * ֪ͨеȴ߳ϵ̣߳ʾͽ
	 * @return {bool}  false ʾ֪ͨʧ
	 */
	bool notify_all(void);

	/**
	 * ߳󶨵̻߳
	 * @return {thread_mutex&}
	 */
	thread_mutex& get_mutex(void) const;

	/**
	 * ϵͳ͵߳
	 * @return {acl_pthread_cond_t*}
	 */
	acl_pthread_cond_t* get_cond(void) const;

private:
	thread_mutex* mutex_;
	thread_mutex* mutex_internal_;
	acl_pthread_cond_t* cond_;

	bool block_wait(bool locked);
	bool timed_wait(long long microseconds, bool locked);
};

} // namespace acl
