#pragma once
#include "../acl_cpp_define.hpp"
#include "dbuf_pool.hpp"
#include <vector>

namespace acl {

class string;

struct URL_NV
{
	char* name;
	char* value;
};

class ACL_CPP_API url_coder : public dbuf_obj
{
public:
	/**
	 * 캯
	 * @param nocase {bool} Ϊ true ʱʾСд
	 * @param dbuf {dbuf_guard*} ڴض
	 */
	url_coder(bool nocase = true, dbuf_guard* dbuf = NULL);

	/**
	 * 캯ͨʵ
	 * @param coder {const url_coder&}
	 * @param dbuf {dbuf_guard*} ڴض
	 */
	url_coder(const url_coder& coder, dbuf_guard* dbuf = NULL);

	~url_coder(void);

	/**
	 * 洢 params_ еݽ url 
	 * @param buf {string&} 洢Ľ
	 * @param clean {bool} Ƿմ buf 
	 */
	void encode(string& buf, bool clean = true) const;

	/**
	 * ýתΪַ
	 * @return {const string&}
	 */
	const string& to_string(void) const;

	/**
	 *  URL ַ
	 * @param str {const char*} url ʽַ
	 */
	void decode(const char* str);
	
	/**
	 *  url ʱô˺ӱ
	 * @param name {const char*} 
	 * @param value ֵ
	 * @param override {bool} ͬǷֱӸ
	 * @return  url_coder 
	 */
	url_coder& set(const char* name, const char* value,
		bool override = true);
	url_coder& set(const char* name, int value, bool override = true);
	url_coder& set(const char* name, bool override, const char* fmt, ...)
		ACL_CPP_PRINTF(4, 5);
	url_coder& set(const char* name, const char* fmt, va_list ap,
		bool override = true);

	/**
	 *  URL  params_ ĳֵ
	 * @param name {const char*} 
	 * @param found {bool*} ָ NULL ʱ洢 name ǷڣҪ
	 *   name ֵΪյ
	 * @return {const char*}  NULL ʾ
	 */
	const char* get(const char* name, bool* found = NULL) const;

	/**
	 *  URL  params_ ĳֵ
	 * @param name {const char*} 
	 * @return {const char*}  NULL ʾڻ name ֵΪ
	 *  ע name ֵΪգȷж name Ƿ
	 */
	const char* operator[](const char* name) const;

	/**
	 * URL Ŀ
	 * @param coder {const url_coder&} URL Դ
	 * @return {const url_coder&}
	 */
	const url_coder& operator =(const url_coder& coder);

	/**
	 * ò
	 * @return {std::vector<URL_NV*>&}
	 */
	const std::vector<URL_NV*>& get_params(void) const
	{
		return params_;
	}

	/**
	 *  params_ ɾĳ
	 * @param name {const char*} 
	 * @return {bool}  true ʾɾɹʾ
	 */
	bool del(const char* name);

	/**
	 * ý״̬ڲ
	 */
	void reset(void);

private:
	bool nocase_;
	dbuf_guard* dbuf_;
	dbuf_guard* dbuf_internal_;
	std::vector<URL_NV*> params_;
	string*  buf_;

	void init_dbuf(dbuf_guard* dbuf);
};

} // namespace acl end
