#pragma once
#include "../acl_cpp_define.hpp"
#include "pipe_stream.hpp"

typedef struct z_stream_s z_stream;

namespace acl {

/**
 * ѹͶ壬ü϶ѹٶȼѹȵһѡʽ
 * ѡѹֵԽߣѹȻ󣬵ѹٶȻԽ
 */
typedef enum
{
	zlib_default = -1,      // ȱʡѹ
	zlib_level0 = 0,        // ͵ѹȣʵǲѹ
	zlib_best_speed = 1,    // ѹٶѹ
	zlib_level1 = zlib_best_speed,
	zlib_level2 = 2,
	zlib_level3 = 3,
	zlib_level4 = 4,
	zlib_level5 = 5,
	zlib_level6 = 6,
	zlib_level7 = 7,
	zlib_level8 = 8,
	zlib_best_compress = 9, // ߵѹȣ͵ѹٶ
	zlib_level9 = zlib_best_compress
} zlib_level_t;

/**
 * ѹеѹڲֵͣԽѹЧԽռڴԽ࣬
 *  HTTP ѹ䣬ҪЩֵĸֵ-zlib_wbits_t
 */
enum
{
	zlib_wbits_8  = 8,
	zlib_wbits_9  = 9,
	zlib_wbits_10 = 10,
	zlib_wbits_11 = 11,
	zlib_wbits_12 = 12,
	zlib_wbits_13 = 13,
	zlib_wbits_14 = 14,
	zlib_wbits_15 = 15,
};

/**
 * ѹеڴԣֵԽʹڴԽ
 */
typedef enum
{
	zlib_mlevel_1 = 1,
	zlib_mlevel_2 = 2,
	zlib_mlevel_3 = 3,
	zlib_mlevel_4 = 4,
	zlib_mlevel_5 = 5,
	zlib_mlevel_6 = 6,
	zlib_mlevel_7 = 7,
	zlib_mlevel_8 = 8,
	zlib_mlevel_9 = 9,
} zlib_mlevel_t;

/**
 * ѹѹеĻģʽѹѹǷˢ
 * Ϊ˻ñȽϸߵѹȣӦѡ zlib_flush_off ʽ
 */
typedef enum
{
	zlib_flush_off = 0,     // ˢû
	zlib_flush_partial = 1, // ˢ²û
	zlib_flush_sync = 2,    // ͬˢ
	zlib_flush_full = 3,    // ȫˢ
	zlib_flush_finish = 4   // ȫˢ²ֹͣѹѹ
} zlib_flush_t;

class string;

class ACL_CPP_API zlib_stream : public pipe_stream
{
public:
	zlib_stream();
	~zlib_stream();

	/**
	 * ʽѹ
	 * @param in {const char*} Դ
	 * @param len {int} Դݳ
	 * @param out {string*} 洢ѹû
	 * @param level {zlib_level_t} ѹ𣬼ԽѹԽߣ
	 *  ѹٶԽ
	 * @return {bool} ѹǷɹ
	 */
	bool zlib_compress(const char* in, int len, string* out,
		zlib_level_t level = zlib_default);

	/**
	 * ʽѹ
	 * @param in {const char*} Դѹ
	 * @param len {int} Դݳ
	 * @param out {string*} 洢ѹû
	 * @param have_zlib_header {bool} Ƿ zlib_header ͷ
	 *  HTTP ЭӦýֵΪ false
	 * @param wsize {int} ѹеĻڴС
	 * @return {bool} ѹǷɹ
	 */
	bool zlib_uncompress(const char* in, int len, string* out,
		bool have_zlib_header = true, int wsize = 15);

	///////////////////////////////////////////////////////////////
	//
	//           Ϊʽѹʽѹ
	//
	///////////////////////////////////////////////////////////////

	/**
	 * ʼѹ̣ʽѹʽ˳ǣ
	 * zip_begin->zip_update->zip_finishмκһ
	 * ʧܣӦõ zip_reset
	 * @param level {zlib_level_t} ѹ𣬼Խߣѹ
	 *  ԽߣѹٶԽ
	 * @param wbits {zlib_wbits_t} ѹеĻڼֵԽ
	 *  ѹЧԽʹڴԽ࣬ HTTP ѹ䣬Ӧòø
	 *  ֵĸֵ磺-zlib_wbits_15
	 * @param mlevel {zlib_mlevel_t} ѹеڴԣֵԽ
	 *  ѹЧԽڴʹԽ
	 * @return {bool} ѹʼǷɹʧܵԭһ
	 *  ӦĲǷ
	 */
	bool zip_begin(zlib_level_t level = zlib_default,
		int wbits = zlib_wbits_15,
		zlib_mlevel_t mlevel = zlib_mlevel_9);

	/**
	 * ѭô˺Դݽѹ
	 * @param in {const char*} Դ
	 * @param len {int} Դݳ
	 * @param out {string*} ûúӷʽû
	 *  ṩĻѹĽûӦжϵñ
	 *  ǰĻȣȷɸúӵݳȣ
	 *  ѡ zlib_flush_t Ĳͬûݿδشȡ
	 *  еĽ
	 * @param flag {zlib_flush_t} ѹеݻ巽ʽ
	 *  zlib_flush_off: ݽܲˢû
	 *    zlib ⱾˢµķʽӶܻýϸߵѹ
	 *  zlib_flush_partial: ݽܻᲿˢû
	 *  zlib_flush_sync: ͬˢû
	 *  zlib_flush_full:  zlib ⻺ݽȫˢû
	 *  zlib_flush_finish: ñѹ̽ͬʱὫ
	 *    нˢûһòҪãΪ
	 *     zip_finish 󣬻ԶеĻˢû
	 * @return {bool} ѹǷʧ
	 */
	bool zip_update(const char* in, int len, string* out,
		zlib_flush_t flag = zlib_flush_off);

	/**
	 * ñʾѹ̽
	 * @param out {string} ûúὫ zlib ⻺
	 *  ӵķʽˢû
	 * @return {bool} Ƿɹ
	 */
	bool zip_finish(string* out);

	/**
	 * ѹ״̬һֻеѹ̳ʱŻñ
	 * @return {bool} Ƿɹ
	 */
	bool zip_reset();

	/**
	 * ѹпʹô˺ݵ crc32 Уֵ
	 * @param n {unsigned} ϴμУֵһʱд 0
	 * @param buf {const void*} ҪУݵַһʹʱд NULL
	 * @param dlen {size_t} buf ݵĳȣһʹʱд 0
	 * @return {unsinged} μУֵ
	 */
	unsigned crc32_update(unsigned n, const void* buf, size_t dlen);

	/**
	 * ʼѹ̣ʽѹʽ˳ǣ
	 * unzip_begin->unzip_update->unzip_finishмκһ
	 * ʧܣӦõ unzip_reset
	 * @param have_zlib_header {bool} Ƿ zlib_header ͷ
	 *  HTTP ЭӦýֵΪ false
	 * @param wsize {int} ѹеĻڴС
	 * @return {bool} ѹʼǷɹʧܵԭһ
	 *  ӦĲǷ
	 */
	bool unzip_begin(bool have_zlib_header = true, int wsize = 15);

	/**
	 * ѭô˺Դݽнѹ
	 * @param in {const char*} ѹԴ
	 * @param len {int} Դݳ
	 * @param out {string*} ûúӷʽû
	 *  ṩĻӽѹĽûӦжϵñ
	 *  ǰĻȣȷɸúӵݳȣ
	 *  ѡ zlib_flush_t Ĳͬûݿδشȡ
	 *  еĽ
	 * @param flag {zlib_flush_t} ѹеݻ巽ʽ
	 *  zlib_flush_off: ݽܲˢû
	 *    zlib Ȿˢµķʽ
	 *  zlib_flush_partial: ݽܻᲿˢû
	 *  zlib_flush_sync: ͬˢû
	 *  zlib_flush_full:  zlib ⻺ݽȫˢû
	 *  zlib_flush_finish: ñѹ̽ͬʱὫ
	 *    нˢûһòҪãΪ
	 *     zip_finish 󣬻ԶеĻˢû
	 * @return {bool} ѹǷʧ
	 */
	bool unzip_update(const char* in, int len, string* out,
		zlib_flush_t flag = zlib_flush_off);

	/**
	 * ñʾѹ̽
	 * @param out {string} ûúὫ zlib ⻺
	 *  ӵķʽˢû
	 * @return {bool} Ƿɹ
	 */
	bool unzip_finish(string* out);

	/**
	 * ýѹ״̬һֻеѹ̳ʱŻñ
	 * @return {bool} Ƿɹ
	 */
	bool unzip_reset();

	/**
	 * õǰ zstream 
	 * @return {z_stream*}
	 */
	z_stream* get_zstream() const
	{
		return zstream_;
	}

	/**
	 * ö̬طʽض̬ʱʹô˺ö̬ļȫ·
	 */
	static void set_loadpath(const char* path);

	/**
	 * ˶̬Ķ̬ȫ·ʱͨö̬ȫ·
	 * @return {const char*} δʱ򷵻 NULL
	 */
	static const char* get_loadpath();

	///////////////////////////////////////////////////////////////

	bool pipe_zip_begin(zlib_level_t level = zlib_default,
		zlib_flush_t flag = zlib_flush_off);
	bool pipe_unzip_begin(zlib_flush_t flag = zlib_flush_off);

	// pipe_stream 麯

	virtual int push_pop(const char* in, size_t len,
		string* out, size_t max = 0);
	virtual int pop_end(string* out, size_t max = 0);
	virtual void clear();

private:
	z_stream* zstream_;
	bool finished_;
	bool is_compress_;
	zlib_flush_t flush_;

	bool update(int (*func)(z_stream*, int), zlib_flush_t flag,
		const char* in, int len, string* out);
	bool flush_out(int (*func)(z_stream*, int),
		zlib_flush_t flag, string* out);
};

} // namespace acl
