#pragma once
#include "../acl_cpp_define.hpp"
#include "aio_istream.hpp"
#include "aio_ostream.hpp"

namespace acl {

class fstream;

/**
 * 첽ļдֻ UNIX ϵͳ
 */
class ACL_CPP_API aio_fstream
	: public aio_istream
	, public aio_ostream
{
public:
	/**
	 * 캯
	 * @param handle {aio_handle*} 첽¼
	 */
	aio_fstream(aio_handle* handle);

#if defined(_WIN32) || defined(_WIN64)
	aio_fstream(aio_handle* handle, HANDLE fd, unsigned int oflags = 0600);
#else
	aio_fstream(aio_handle* handle, int fd, unsigned int oflags = 0600);
#endif

	/**
	 * ļ·ļ, Ĵļķʽ
	 * @param path {const char*} ļ
	 * @param oflags {unsigned int} ־λ, We're assuming that O_RDONLY: 0x0000,
	 *  O_WRONLY: 0x0001, O_RDWR: 0x0002, O_APPEND: 0x0008, O_CREAT: 0x0100,
	 *  O_TRUNC: 0x0200, O_EXCL: 0x0400; just for win32, O_TEXT: 0x4000,
	 *  O_BINARY: 0x8000, O_RAW: O_BINARY, O_SEQUENTIAL: 0x0020, O_RANDOM: 0x0010.
	 * @param mode {int} ļʱģʽ(: 0600)
	 * @return {bool} ļǷɹ
	 */
	bool open(const char* path, unsigned int oflags, unsigned int mode);

	/**
	 * Զ/дʽļļʱ򴴽ļļʱ
	 * ļ, ļΪ 0700
	 * @param path {const char*} ļ
	 * @param mode {int} ļʱģʽ(: 0600)
	 * @return {bool} ļǷɹ
	 */
	bool open_trunc(const char* path, unsigned int mode = 0600);

	/**
	 * Զ/дʽļļΪ 0600, ļ򴴽ļ
	 * 򿪾ļ
	 * @param path {const char*} ļȫ·
	 * @param mode {int} ļʱģʽ(: 0600)
	 * @return {bool} ļǷɹ
	 */
	bool create(const char* path, unsigned int mode = 0600);

	/**
	 * ֻʽѾڵļ
	 * @param path {const char*} ļ
	 * @return {bool} ļǷɹ
	 */
	bool open_read(const char* path);

	/**
	 * ֻдʽļļ򴴽ļļ
	 * ڣļ
	 * @param path {const char*} ļ
	 * @return {bool} Ƿɹ
	 */
	bool open_write(const char* path);

	/**
	 * βӷʽļļ򴴽ļ
	 * @param path {const char*} ļ
	 * @return {bool} Ƿɹ
	 */
	bool open_append(const char* path);

protected:
	~aio_fstream(void);
	/**
	 * ͨ˺̬ͷֻڶϷ첽
	 */
	virtual void destroy(void);

private:
};

}  // namespace acl
