#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "../stdlib/noncopyable.hpp"

struct ACL_AIO;
struct ACL_EVENT;

namespace acl
{

// ¼
typedef enum
{
	ENGINE_SELECT,  // select ģʽ(֧ƽ̨)
	ENGINE_POLL,    // poll ģʽ( UNIX ƽ̨)
	ENGINE_KERNEL,  // kernel ģʽ(win32: iocp, Linux: epoll, FreeBsd: kqueue, Solaris: devpoll
	ENGINE_WINMSG   // win32 GUI Ϣģʽ
} aio_handle_type;

/**
 * IO¼࣬װϵͳ select/poll/epoll/kqueue/devpoll/iocp,
 */

class aio_timer_callback;
class aio_delay_free;
class aio_timer_delay_free;

class ACL_CPP_API aio_handle : private noncopyable
{
public:
	/**
	 * 캯ԶIO¼棬лԶͷ
	 * @param engine_type {aio_handle_type} õ
	 *  ENGINE_SELECT: select ʽ֧ win32/unix ƽ̨
	 *  ENGINE_POLL: poll ʽ֧ unix ƽ̨
	 *  ENGINE_KERNEL: Զݸϵͳƽֵ̨֧ĸЧں
	 *  ENGINE_WINMSG: win32 Ϣʽ֧ win32 ƽ̨
	 * @param nMsg {unsigned int}  engine_type Ϊ ENGINE_WINMSGֵ
	 *   0 ʱ첽Ϣ󶨣ȱʡϢ󶨣
	 *   engine_type Ϊ ENGINE_WINMSG ʱֵ첽
	 *  
	 */
	aio_handle(aio_handle_type engine_type = ENGINE_SELECT,
		unsigned int nMsg = 0);

	/**
	 * 캯߽ ACL_AIO в
	 * ԶͷŸ ACL_AIO 
	 * @param handle {ACL_AIO*} ACL_AIO 
	 */
	aio_handle(ACL_AIO* handle);

	virtual ~aio_handle(void);

	/**
	 * 첽ǷᱻеĻ
	 * 첽첽̳Уһ aio_handle ȱʡ
	 * 
	 * @param onoff {bool} Ƿ
	 */
	void keep_read(bool onoff);

	/**
	 * 첽Ƿ˳ݵĹ
	 * @return {bool}
	 */
	bool keep_read(void) const;

	/**
	 * öʱ
	 * @param callback {aio_timer_callback*} ʱص
	 * @param delay {int64} ʱʱ(΢)
	 * @param id {unsigned int} ʱĳ ID 
	 * @return {int64} ʱЧʱ(1970.1.1΢)
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 set_timer(aio_timer_callback* callback,
		__int64 delay, unsigned int id = 0);
#else
	long long int set_timer(aio_timer_callback* callback,
		long long int delay, unsigned int id = 0);
#endif

	/**
	 * ɾʱжʱ¼
	 * @param callback {aio_timer_callback*} ʱص
	 * @return {time_t} ʱЧʱ(1970.1.1΢)
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 del_timer(aio_timer_callback* callback);
#else
	long long int del_timer(aio_timer_callback* callback);
#endif

	/**
	 * ɾʱĳָ ID ŵĶʱ
	 * @param callback {aio_timer_callback*} ʱص
	 * @param id {unsigned int} ʱĳ ID 
	 * @return {time_t} ʱЧʱ(1970.1.1΢)
	 */
#if defined(_WIN32) || defined(_WIN64)
	__int64 del_timer(aio_timer_callback* callback, unsigned int id);
#else
	long long del_timer(aio_timer_callback* callback, unsigned int id);
#endif

	/**
	 * ʱ״̬ʱûΪ޷ͷŸöʱڴй¶
	 * ͨ˺Խ״̬Ķʱδ״̬ʱ¼
	 * ͷ( aio_delay_free::destroy())ӶԱ
	 * ڴй¶
	 * @param callback {aio_delay_free*}
	 */
	void delay_free(aio_delay_free* callback);

	/**
	 *  ACL_AIO 
	 * @return {ACL_AIO*}
	 */
	ACL_AIO* get_handle(void) const;

	/**
	 * 첽
	 * @return {aio_handle_type}
	 */
	aio_handle_type get_engine_type(void) const;

	/**
	 * õǰڼص첽
	 * @return {int}
	 */
	int length(void) const;

	/**
	 * 첽״̬׼첽Ĵ
	 * @return {bool} ǷӦֹ첽
	 */
	bool check(void);

	/**
	 * ñ¼ѭ¼
	 * @return {int}
	 */
	int last_nready(void) const;

	/**
	 * ֪ͨ첽ֹ
	 */
	void stop(void);

	/**
	 * 첽ڲ״̬
	 */
	void reset(void);

	/**
	 *  DNS ַбʽip1:port1;ip2:port2...
	 * @param addrs {const char*} DNS ַб磺8.8.8.8:53;1.1.1.1:53
	 * @param timeout {int} DNS ѯʱʱ䣨룩
	 *  עset_dns  dns_add ִͬĹ
	 */
	void set_dns(const char* addrs, int timeout);
	void dns_add(const char* addrs, int timeout);

	/**
	 * ɾָ DNS ַбʽip1:port1;ip2:port2...
	 * @param addrs {const char*} DNS ַб
	 */
	void dns_del(const char* addrs);

	/**
	 * õ DNS б
	 */
	void dns_clear(void);

	/**
	 * DNS б
	 * @return {size_t}
	 */
	size_t dns_size(void) const;

	/**
	 * ж DNS бǷΪ
	 * @return {bool}
	 */
	bool dns_empty(void) const;
	
	/**
	 *  DNS ַб
	 * @param out {std::vector<std::pair<acl::string, unsigned short> >&}
	 */
	void dns_list(std::vector<std::pair<string, unsigned short> >& out);

public:
	/**
	 * 첽ѭĵȴʱе뼶
	 * @param n {int}  select/poll/epoll/kqueue/devpoll
	 *  ʱ뼶ȴʱ
	 */
	void set_delay_sec(int n);

	/**
	 * 첽ѭĵȴʱе΢뼶
	 * @param n {int}  select/poll/epoll/kqueue/devpoll
	 *  ʱ΢뼶ȴʱ
	 */
	void set_delay_usec(int n);

	/**
	 * ¼ѭжʱ״̬ʱ
	 * ڲȱʡֵ 100 ms
	 */
	void set_check_inter(int n);

	/**
	 * 첽ĶС
	 * @param n {int} С
	 */
	void set_rbuf_size(int n);

protected:
	friend class aio_stream;

	/**
	 * 첽 1
	 */
	void increase(void);

	/**
	 * 첽 1 ʱĻص麯
	 */
	virtual void on_increase(void) {}

	/**
	 * 첽 1
	 */
	void decrease(void);

	/**
	 * 첽 1 ʱĻص麯
	 */
	virtual void on_decrease(void) {}

private:
	ACL_AIO* aio_;
	bool inner_alloc_;
	bool stop_;
	int  nstream_;
	aio_handle_type engine_type_;
	aio_timer_delay_free* delay_free_timer_;

	void destroy_timer(aio_timer_callback* callback);
	static void on_timer_callback(int event_type, ACL_EVENT*,
		aio_timer_callback *callback);
};

} // namespace acl
