#pragma once
#include "../acl_cpp_define.hpp"
#if defined(_WIN32) || defined(_WIN64)
# include <WinSock2.h>
#endif
#include "aio_istream.hpp"
#include "aio_ostream.hpp"

namespace acl
{

/**
 * 첽ͻ첽Զ̷ʱĻص࣬Ϊ࣬
 * Ҫʵ open_callback ص
 */
class ACL_CPP_API aio_open_callback : public aio_callback
{
public:
	aio_open_callback(void) {}
	virtual ~aio_open_callback(void) {}

	virtual bool open_callback(void) = 0;
protected:
private:
};

struct AIO_OPEN_CALLBACK 
{
	aio_open_callback* callback;
	bool enable;
};

class aio_handle;

/**
 * 첽̳࣬첽дͬʱֻڶϷ䣬
 * ջϷ䣬ҸʱӦòͷŸΪ첽
 * ڲԶͷŸӦÿԵ close ر
 */
class ACL_CPP_API aio_socket_stream
	: public aio_istream
	, public aio_ostream
{
public:
	/**
	 * 캯첽ͻ
	 * @param handle {aio_handle*} 첽
	 * @param stream {ACL_ASTREAM*} 
	 * @param opened {bool} ǷѾӣԶ
	 *  hook д̼ر/ʱ̣ hook ر/ʱ
	 */
	aio_socket_stream(aio_handle* handle, ACL_ASTREAM* stream, bool opened = false);

	/**
	 * 캯첽ͻ hook д̼ر/ʱ
	 * @param handle {aio_handle*} 첽
	 * @param fd {int} ׽ӿھ
	 */
#if defined(_WIN32) || defined(_WIN64)
	aio_socket_stream(aio_handle* handle, SOCKET fd);
#else
	aio_socket_stream(aio_handle* handle, int fd);
#endif

	/**
	 * Զ̷ӣԶ hook ĹرաʱԼӳɹ
	 * ʱĻص
	 * @param handle {aio_handle*} 첽
	 * @param addr {const char*} Զ̷ĵַַʽΪ
	 *  TCPIP:Port  ׽ӿڣ{filePath}
	 * @param timeout {int} ӳʱʱ()
	 * @return {bool} ʧú false
	 *  true ֻǱʾӹУǷʱǷʧ
	 *  Ӧͨصж
	 */
	static aio_socket_stream* open(aio_handle* handle,
		const char* addr, int timeout);

	/**
	 *  open Ļص
	 * @param callback {aio_open_callback*} ص
	 */
	void add_open_callback(aio_open_callback* callback);

	/**
	 *  open ص󼯺ɾ
	 * @param callback {aio_open_callback*} ɾĻص
	 *  ֵΪգɾеĻص
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_open_callback(aio_open_callback* callback = NULL);

	/**
	 * ֹص༯еĳص󣬵ӻص
	 * ɾֻǲö
	 * @param callback {aio_open_callback*} ֹĻص
	 *  ֵΪգֹеĻص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_open_callback(aio_open_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_open_callback*} ָĻص
	 * ֵΪգеĻص
	 * @return {int} رõĻصĸ
	 */
	int enable_open_callback(aio_open_callback* callback = NULL);

	/**
	 *  open ̣жǷѾӳɹ
	 * @return {bool}  true ʾӳɹʾӳɹ
	 */
	bool is_opened(void) const;

protected:
	virtual ~aio_socket_stream(void);

	/**
	 * ͨ˺̬ͷֻڶϷ첽
	 */
	virtual void destroy(void);

	/**
	 * עӳɹĻص
	 */
	void hook_open(void);

private:
	std::list<AIO_OPEN_CALLBACK*>* open_callbacks_;

	static int open_callback(ACL_ASTREAM*, void*);
};

}  // namespace acl
