#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"
#include <list>
#include <string>
#if defined(_WIN32) || defined(_WIN64)
#include <WinSock2.h>
#endif

struct ACL_ASTREAM;
struct ACL_VSTREAM;

namespace acl
{

/**
 * 첽ص
 */
class ACL_CPP_API aio_callback : public noncopyable
{
public:
	aio_callback(void) {}
	virtual ~aio_callback(void) {};

	virtual void close_callback(void) {}
	virtual bool timeout_callback(void)
	{
		return false;
	}

	/**
	 * ص麯ûص aio_istream ʵе
	 * gets/read Ŀɶ󱻵ã첽ڲ
	 * ݶֱӴݸû
	 * @param data {char*} ݵַָ
	 * @param len {int} ݳ(> 0)
	 * @return {bool} ú false ֪ͨ첽رո첽
	 */
	virtual bool read_callback(char* data, int len)
	{
		(void) data;
		(void) len;
		return true;
	}

	/**
	 * ص麯ûص aio_istream ʵе
	 * read_wait Ŀɶ첽ݿɶʱãʱʱ
	 *  timeout_callback쳣رʱ close_callback
	 */
	virtual bool read_wakeup(void)
	{
		return true;
	}

	/**
	 * дɹĻص麯
	 * @return {bool} ú false ֪ͨ첽رո첽
	 */
	virtual bool write_callback(void)
	{
		return true;
	}

	/**
	 * ص麯ûص aio_ostream ʵе
	 * write_wait Ŀд첽дʱãʱʱ
	 *  timeout_callback쳣رʱ close_callback
	 */
	virtual bool write_wakeup(void)
	{
		return true;
	}
};

struct AIO_CALLBACK 
{
	aio_callback* callback;
	bool enable;
};

class aio_handle;
class stream_hook;

/**
 * 첽࣬Ϊֱܱ࣬ʵֻܱ̳ʹ
 * ֻڶϷ䣬ջϷ
 */
class ACL_CPP_API aio_stream : public noncopyable
{
public:
	/**
	 * 캯
	 * @param handle {aio_handle*}
	 */
	aio_stream(aio_handle* handle);

	/**
	 * ر첽
	 */
	void close(void);

	/**
	 * ӹرʱĻصָ룬ûصѾڣֻ
	 * ʹöڴ򿪿״̬
	 * @param callback {aio_callback*} ̳ aio_callback ص
	 *  첽رǰȵô˻صе close_callback ӿ
	 */
	void add_close_callback(aio_callback* callback);

	/**
	 * ӳʱʱĻصָ룬ûصѾڣֻ
	 * ʹöڴ򿪿״̬
	 * @param callback {aio_callback*} ̳ aio_callback ص
	 *  첽رǰȵô˻صе timeout_callback ӿ
	 */
	void add_timeout_callback(aio_callback* callback);

	/**
	 * ɾرʱĻصָ
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգɾеĹرջص
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_close_callback(aio_callback* callback = NULL);

	/**
	 * ɾʱʱĻصָ
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգɾеĳʱص
	 * @return {int} رӻص󼯺ɾĻصĸ
	 */
	int del_timeout_callback(aio_callback* callback = NULL);

	/**
	 * ֹرյĻص󣬵ӹرն󼯺ɾ
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգֹеĹرջص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_close_callback(aio_callback* callback = NULL);

	/**
	 * ֹʱĻص󣬵ӳʱ󼯺ɾ
	 * @param callback {aio_callback*}  aio_callback ̳еָ룬
	 *  ֵΪգֹеĳʱص
	 * @return {int} رӻص󼯺нõĻصĸ
	 */
	int disable_timeout_callback(aio_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_callback*} ָĻصֵΪգ
	 *  еĹرջص
	 * @return {int} رõĻصĸ
	 */
	int enable_close_callback(aio_callback* callback = NULL);

	/**
	 * еĻص󱻵
	 * @param callback {aio_callback*} ָĻصֵΪգ
	 *  еĳʱص
	 * @return {int} رõĻصĸ
	 */
	int enable_timeout_callback(aio_callback* callback = NULL);

	/**
	 * 첽 ACL_ASTREAM
	 * @return {ACL_ASTREAM*}
	 */
	ACL_ASTREAM* get_astream(void) const;

	/**
	 * 첽еͬ ACL_VSTREAM
	 * @return {ACL_VSTREAM*}
	 */
	ACL_VSTREAM* get_vstream(void) const;

	/**
	 * 첽е SOCKET 
	 * @return {ACL_SOCKET} 򷵻 -1(UNIX)  INVALID_SOCKET(win32)
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET get_socket(void) const;
	SOCKET sock_handle(void) const
#else
	int get_socket(void) const;
	int sock_handle(void) const
#endif
	{
		return get_socket();
	}

	/**
	 * Զӵĵַ
	 * @param full {bool} ǷַIP:PORTò
	 *  Ϊ false IP򷵻 IP:PORT
	 * @return {const char*} Զӵֵַ == '\0' ʾ
	 *  ޷Զӵַ
	 */
	const char* get_peer(bool full = false) const;

	/**
	 * ӵıصַ
	 * @param full {bool} ǷַIP:PORTò
	 *  Ϊ false IP򷵻 IP:PORT
	 * @return {const char*} ӵıصֵַ == "" ʾ
	 *  ޷ñصַ
	 */
	const char* get_local(bool full = false) const;

	/**
	 * 첽¼
	 * @return {aio_handle&}
	 */
	aio_handle& get_handle(void) const;

	/**
	 * עдڲԶ hook->open ̣ɹ򷵻֮ǰע
     * Ķ(ΪNULL)ʧ򷵻ָͬ룬Ӧÿͨж
     * ֵֵǷͬжעǷɹ
	 * xxx: ڵô˷ǰ뱣֤Ѿ
	 * @param hook {stream_hook*} ǿնָ
	 * @return {stream_hook*} ֵֵͬʾɹ
	 */
	stream_hook* setup_hook(stream_hook* hook);

	/**
	 * õǰעд
	 * @return {stream_hook*}
	 */
	stream_hook* get_hook(void) const;

	/**
	 * ɾǰעд󲢷ظö󣬻ָȱʡĶд
	 * @return {stream_hook*}
	 */
	stream_hook* remove_hook(void);

protected:
	aio_handle*  handle_;
	ACL_ASTREAM* stream_;
	stream_hook* hook_;

	virtual ~aio_stream(void);

	/**
	 * ͨ˺̬ͷֻڶϷ첽
	 */
	virtual void destroy(void);

	/**
	 * Ӧڴɹøú֪ͨ첽,
	 * ͬʱ hook رռʱʱĻص
	 */
	void hook_error(void);

protected:
	enum {
		// Ƿ hook_xxx Ӧı־λ
		STATUS_HOOKED_ERROR = 1,
		STATUS_HOOKED_READ  = 1 << 1,
		STATUS_HOOKED_WRITE = 1 << 2,
		STATUS_HOOKED_OPEN  = 1 << 3,

		//  aio_socket_stream ʾǷѽ
		STATUS_CONN_OPENED  = 1 << 4,
	};
	unsigned status_;
private:
	std::list<AIO_CALLBACK*>* close_callbacks_;
	std::list<AIO_CALLBACK*>* timeout_callbacks_;

	static int close_callback(ACL_ASTREAM*, void*);
	static int timeout_callback(ACL_ASTREAM*, void*);

private:
	std::string ip_peer_;
    std::string ip_local_;

	const char* get_ip(const char* addr, std::string& out);

private:
#if defined(_WIN32) || defined(_WIN64)
	static int read_hook(SOCKET fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int send_hook(SOCKET fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);

	static int fread_hook(HANDLE fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int fsend_hook(HANDLE fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#else
	static int read_hook(int fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int send_hook(int fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);

	static int fread_hook(int fd, void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
	static int fsend_hook(int fd, const void *buf, size_t len,
		int timeout, ACL_VSTREAM* stream, void *ctx);
#endif
};

}  // namespace acl
