#pragma once
#include "../acl_cpp_define.hpp"
#include <list>
#include "aio_delay_free.hpp"

namespace acl
{

class aio_timer_task;
class aio_handle;

/**
 * ʱĻص
 */
class ACL_CPP_API aio_timer_callback : public aio_delay_free
{
public:
	/**
	 * 캯
	 * @param keep {bool} öʱǷԶ
	 */
	aio_timer_callback(bool keep = false);
	virtual ~aio_timer_callback(void);

	/**
	 * ʱΪʱĻص
	 * ͷţһúã
	 * ζŸöʱежʱ񶼴
	 * ʱбɾ
	 * ú
	 * 1) ʱеΪ 0 ʱ(磬
	 *    del_timer(aio_timer_callback*, unsigned int) 
	 *    Ϊ 0 ʱ)
	 * 2)  aio_handle ûظʱҸöʱ
	 *    һʱ񱻴
	 * 3)  del_timer(aio_timer_callback*) ú
	 */
	virtual void destroy(void) {}

	/**
	 * ʱǷΪ
	 * @return {bool}
	 */
	bool empty(void) const;

	/**
	 * ʱ
	 * @return {size_t}
	 */
	size_t length(void) const;

	/**
	 * öʱǷԶ
	 * @param on {bool}
	 */
	void keep_timer(bool on);

	/**
	 * жϸöʱǷԶ
	 * @return {bool}
	 */
	bool keep_timer(void) const;

	/**
	 * նʱĶʱ
	 * @return {int} Ķʱĸ
	 */
	int clear(void);

protected:
	friend class aio_handle;

	/**
	 * ʵִ˻صעֹ߽
	 * timer_callback ڲ aio_timer_callback 
	 * 򽫻ɴ
	 * @param id {unsigned int} Ӧĳ ID 
	 */
	virtual void timer_callback(unsigned int id) = 0;

	/****************************************************************/
	/*        ԵºһЩµĶʱ ID               */
	/****************************************************************/
#if defined(_WIN32) || defined(_WIN64)
	__int64 present_;

	/**
	 * ԱʱµIDţͨһʱ
	 * ʱ
	 * @param id {unsigned int} ʱʱID
	 * @param delay {__int64} ÿԶöʱͬʱӦĶʱʱ
	 *  IDŴ(΢뼶)
	 * @return {__int64} 뱾ʱĵһᴥĶʱID(΢뼶)
	 */
	__int64 set_task(unsigned int id, __int64 delay);

	/**
	 * ɾʱĳϢIDӦĶʱ
	 * @param {unsigned int} ʱID
	 * @return {__int64} 뱾ʱĵһᴥĶʱID(΢뼶)
	 */
	__int64 del_task(unsigned int id);
#else
	long long int present_;
	long long int set_task(unsigned int id, long long int delay);
	long long int del_task(unsigned int id);
#endif

	/**
	 * õǰʱʱ
	 */
	void set_time(void);

private:
	aio_handle* handle_;
	size_t length_;
	std::list<aio_timer_task*> tasks_;
	bool keep_;  // öʱǷԶ
	bool destroy_on_unlock_;  // Ƿ destroy
#if defined(_WIN32) || defined(_WIN64)
	__int64 set_task(aio_timer_task* task);
	__int64 trigger(void);
#else
	long long int set_task(aio_timer_task* task);
	long long int trigger(void);
#endif
};

} // namespace acl
