#pragma once
#include "../acl_cpp_define.hpp"
#include "istream.hpp"
#include "ostream.hpp"

namespace acl {

class string;

class ACL_CPP_API fstream
	: public istream
	, public ostream
{
public:
	fstream(void);
	virtual ~fstream(void);

	/**
	 * ļ·ļ, Ĵļķʽ
	 * @param path {const char*} ļ
	 * @param oflags {unsigned int} ־λ, We're assuming that
	 *  O_RDONLY: 0x0000, O_WRONLY: 0x0001, O_RDWR: 0x0002,
	 *  O_APPEND: 0x0008, O_CREAT: 0x0100, O_TRUNC: 0x0200,
	 *  O_EXCL: 0x0400; just for win32, O_TEXT: 0x4000,
	 *  O_BINARY: 0x8000, O_RAW: O_BINARY, O_SEQUENTIAL: 0x0020,
	 *  O_RANDOM: 0x0010.
	 * @param mode {int} ļʱģʽ(: 0600)
	 * @return {bool} ļǷɹ
	 */
	bool open(const char* path, unsigned int oflags, int mode);

	/**
	 * Զ/дʽļļʱ򴴽ļļʱ
	 * ļ, ļΪ 0700
	 * @param path {const char*} ļ
	 * @return {bool} ļǷɹ
	 */
	bool open_trunc(const char* path);

	/**
	 * Զ/дʽļļΪ 0700, ļ򴴽ļ
	 * 򿪾ļ
	 * @return {bool} ļǷɹ
	 */
	bool create(const char* path);

	/**
	 * ӦļӴɾúֻеڲ֪ļ·
	 * ʱȷɾļ޷ɾ
	 * @return {bool} ɾļǷɹ
	 */
	bool remove(void);

	/**
	 * ǰļΪָļ WINDOWS ƽ̨Ҫȹرյǰļ
	 * ɹ´µĿļ
	 * @param from_path {const char*} Դļ
	 * @param to_path {const char*} Ŀļ
	 * @return {bool} Ƿɹ
	 */
	bool rename(const char* from_path, const char* to_path);

#if defined(_WIN32) || defined(_WIN64)
	/**
	 * ϵͳļ fstream ļ
	 * @param fh ϵͳļ
	 * @param oflags 򿪱־λ
	 * @param path {const char*}  NULL ʱΪļļ·
	 *  洢Ա file_path, remove ʹ
	 */
	void open(void* fh, unsigned int oflags, const char* path = NULL);

	/**
	 * ƶļָλ
	 * @param offset {__int64} ƫ
	 * @param whence {int} ƶSEEK_SETļʼλúƶ,
	 *  SEEK_CUR(ӵǰļָλƶ), SEEK_END(ļβǰƶ)
	 * @return {acl_off_t} ʱֵ >= 0ʱ -1
	 */
	__int64 fseek(__int64 offset, int whence);

	/**
	 * õǰϵͳļָļеƫλ
	 * @return {acl_off_t} ʱֵ >= 0ʱ -1
	 */
	__int64 ftell(void);

	/**
	 * ļߴضָС
	 * @param length {acl_off_t} ļضϺĴСߴ
	 * @return {bool} Ƿɹ
	 */
	bool ftruncate(__int64 length);

	/**
	 * õǰļĴС
	 * @return {acl_off_t} ʱֵ >= 0 -1
	 */
	__int64 fsize(void) const;

	/**
	 * ̬ڻȡָļļС
	 * @param path {const char*} ǿַָļ·
	 * @return {__int64} ʱֵ >= 0ʱ -1
	 */
	static __int64 fsize(const char* path);

	/**
	 * ϵͳļ
	 * @return ϵͳļʱ ACL_FILE_INVALID
	 */
	void* file_handle(void) const;
#else
	void open(int fh, unsigned int oflags, const char* path = NULL);
	long long int fseek(long long int offset, int whence);
	long long int ftell(void);
	bool ftruncate(long long int length);
	long long int fsize(void) const;
	static long long int fsize(const char* path);
	int file_handle(void) const;
#endif
	/**
	 * ļȫ·
	 * @return {const char*} ؿʾļδ򿪻
	 */
	const char* file_path(void) const;

	/**
	 * ļ򿪺󣬸÷ļ
	 * @param exclude {bool} ʽǷǶռĬǶռֵ
	 * Ϊ false, Ϊ
	 * @return {bool}  false ʾʧܣͨ acl::last_serror 鿴
	 *  ԭ
	 */
	bool lock(bool exclude = true);

	/**
	 * ļ򿪺󣬸÷Զļɹ򷵻 true
	 * ļѾ̼򷵻 false
	 * @param exclude {bool} ʽǷǶռĬǶռֵ
	 * Ϊ false, Ϊ
	 * @return {bool}  false ʾʧܣͨ acl::last_serror 鿴
	 *  ԭ
	 */
	bool try_lock(bool exclude = true);

	/**
	 *  lock  try_lock ɹԵñļ
	 * @return {bool} Ƿɹ
	 */
	bool unlock(void);
};

} // namespace acl
