#pragma once
#include "../acl_cpp_define.hpp"
#include <stdlib.h>
#include "stream.hpp"

namespace acl {

class string;

/**
 * ࣬ȷ֪Ƿرջļ
 * βӦͨ stream->eof() ж
 */

class ACL_CPP_API istream : virtual public stream
{
public:
	istream(void) {}
	virtual ~istream(void) {}

	/**
	 * ж
	 * @param buf {void*} û
	 * @param size {size_t} û
	 * @param loop {bool} Ƿ size ŷ
	 * @return {int} , -1 ʾرջ, > 0 ʾɹ
	 */
	int read(void* buf, size_t size, bool loop = true);

	/**
	 * ֱҪַŷ
	 * @param buf {void*} û
	 * @param inout {size_t*} Ϊʱ *inout ʾ buf
	 *  ĿռСغ¼洢 buf еݳ
	 * @param tag {const char*} Ҫַ
	 * @param len {size_t} tag ַĳ
	 * @return {bool} ǷҪַ
	 */

	bool readtags(void *buf, size_t* inout, const char *tag, size_t len);

	/**
	 * жһ
	 * @param buf {void*} û
	 * @param size_inout {size_t*} Ϊʱ *size_inout ʾ buf
	 *  ĿռСغ¼洢 buf еݳ
	 * @param nonl {bool} Ϊ true Ὣһβ "\r\n"
	 *   "\n" ȥ*size_inout 洢ݳȥ "\r\n"  "\n" 
	 *  ĳȣ򣬱е "\r\n"  "\n"ͬʱ *size_inout 
	 *  ǰ "\r\n"  "\n" ݳ
	 * @return {bool} Ƿһ, 򷵻 false; ļ
	 *  ԣһⲿݲ "\r\n"  "\n"
	 *  Ҳ᷵ false, Ҫ *size_inout ֵǷ 0
	 *  ȷǷһ
	 */
	bool gets(void* buf, size_t* size_inout, bool nonl = true);

	/**
	 * жһ 64 λ
	 * @param n {acl_int64&} 64 λ
	 * @param loop {bool} Ƿʽ8ֽ
	 * @return {bool} Ƿȡɹ
	 */
#if defined(_WIN32) || defined(_WIN64)
	bool read(__int64& n, bool loop = true);
#else
	bool read(long long int& n, bool loop = true);
#endif

	/**
	 * жһ 32 λ
	 * @param n {int&} 32 λ
	 * @param loop {bool} Ƿʽ4ֽ
	 * @return {bool} Ƿȡɹ
	 */
	bool read(int& n, bool loop = true);

	/**
	 * жһ 16 λ
	 * @param n {short&} 16 λ
	 * @param loop {bool} Ƿʽ2ֽ
	 * @return {bool} Ƿȡɹ
	 */
	bool read(short& n, bool loop = true);

	/**
	 * жȡһֽ
	 * @param ch {char&}
	 * @return {bool} ȡǷɹ
	 */
	bool read(char& ch);

	/**
	 * ж
	 * @param s {string*} ڲԶոû
	 * @param loop {bool} Ƿʽ壬
	 *  Ϊ s.capacity()
	 * @return {bool} Ƿɹ
	 */
	bool read(string& s, bool loop = true);
	bool read(string* s, bool loop = true);

	/**
	 * ж
	 * @param s {string*} ڲԶոû
	 * @param max {size_t} ϣݵֵ
	 * @param loop {bool} ǷҪ max ֽΪֹ
	 * @return {bool} Ƿɹ
	 */
	bool read(string& s, size_t max, bool loop = true);
	bool read(string* s, size_t max, bool loop = true);

	/**
	 * жһ
	 * @param s {string&} ڲԶոû
	 * @param nonl {bool} Ƿе "\r\n"  "\n"
	 * @param max {size_t} ֵ > 0 ʱֵ޶еֵ
	 *  յгȴڸֵʱزݣͬʱڲ¼棻
	 *  ֵ = 0 ʱݳ
	 * @return {bool} Ƿһ
	 *  1 true ˵һݣֻ
	 *     "\r\n"  "\n" s Ϊգs.empty() == true
	 *  2 false ˵رδһݣʱ s п
	 *     洢ŲݣҪ if (s.empty() == true) жһ
	 */
	bool gets(string& s, bool nonl = true, size_t max = 0);
	bool gets(string* s, bool nonl = true, size_t max = 0);

	/**
	 * жֱҪַΪָݣ
	 * ȡݵ󲿷ӦǸַ
	 * @param s {string&} ڲԶոû
	 * @param tag {const string&} Ҫַ
	 * @return {bool} ǷҪַ
	 */
	bool readtags(string& s, const string& tag);
	bool readtags(string* s, const string& tag);

	/**
	 * жһֽ
	 * @return {int} ֽڵ ASCII ֵֵΪ -1 ʾԷرջ
	 *  
	 */
	int getch(void);

	/**
	 * зżһֽڵ
	 * @param ch {int} һַ ASCII ֵ
	 * @return {int} ֵ ch ֵͬʾȷʾ
	 */
	int ugetch(int ch);

	/**
	 * Դжȡһ
	 * @param buf {string&} 
	 * @param nonl {bool} Ƿе "\r\n"  "\n"
	 * @param clear {bool} ǷڲԶ buf 
	 * @param max {int} ֵ > 0 ʱݵ󳤶ԱⱾ
	 *  
	 * @return {bool} Ƿһ;  false ʾ
	 *  ֻǱʾδһݣӦͨ stream->eof()
	 *  Ƿرգ⣬˲ݣ buf 洢
	 *  Щ
	 *  ע⣺Ϊ˷ֹ buf ߵø÷õݼʹ
	 *  һݣӦȡ buf еȻ buf->clear()Էֹ buf
	 *  ڴ»
	 */
	bool gets_peek(string& buf, bool nonl = true,
		bool clear = false, int max = 0);
	bool gets_peek(string* buf, bool nonl = true,
		bool clear = false, int max = 0);

	/**
	 * Դжȡ
	 * @param buf {string&} 
	 * @param clear {bool} ʼʱǷڲԶ buf 
	 * @return {bool} Ƿ,  false  ʾδҪ
	 *  ݳȣӦͨ stream->eof() Ƿر
	 *  ע⣺Ϊ˷ֹ buf ߵø÷õݼʹ
	 *  һݣӦȡ buf еȻ buf->clear()Էֹ buf
	 *  ڴ»
	 */
	bool read_peek(string& buf, bool clear = false);
	bool read_peek(string* buf, bool clear = false);

	/**
	 * Դжȡ
	 * @param buf {void*} 
	 * @param size {size_t} buf С
	 * @return {int}  -1 ʾرգ> 0 ʾݳȣ
	 *   0 ʾûжݣԼֵ < 0 ʱ
	 *  ͨ eof() жǷӦùر
	 */
	int read_peek(void* buf, size_t size);

	/**
	 * Դжȡָȵ
	 * @param buf {string&} 
	 * @param cnt {size_t} Ҫݳ
	 * @param clear {bool} ʼʱǷڲԶ buf 
	 * @return {bool} ǷҪݳȵ,  false 
	 *  ʾδҪݳȣӦͨ stream->eof() 
	 *  Ƿر
	 *  ע⣺Ϊ˷ֹ buf ߵø÷õݼʹ
	 *  һݣӦȡ buf еȻ buf->clear()Էֹ buf
	 *  ڴ»
	 */
	bool readn_peek(string& buf, size_t cnt, bool clear = false);
	bool readn_peek(string* buf, size_t cnt, bool clear = false);

	/* ¼Ƕʽ̣Ҫ
	 *  stream->eof() жǷرջǷļβ
	 */

	istream& operator>>(string& s);
#if defined(_WIN32) || defined(_WIN64)
	istream& operator>>(__int64& n);
#else
	istream& operator>>(long long int& n);
#endif
	istream& operator>>(int& n);
	istream& operator>>(short& n);
	istream& operator>>(char& ch);
};

} // namespace acl
