#pragma once
#include "../acl_cpp_define.hpp"
#if defined(_WIN32) || defined(_WIN64)
#include <WinSock2.h>
#endif
#include <string>
#include "istream.hpp"
#include "ostream.hpp"

struct ACL_VSTREAM;

namespace acl {

class ACL_CPP_API socket_stream
	: public istream
	, public ostream
{
public:
	socket_stream(void);
	virtual ~socket_stream(void);

	/**
	 * ׽ִ򿪵һ
	 * @param fd ׽
	 * @param udp_mode {bool} Ƿ UDP ʽ
	 * @return {bool} Ƿɹ
	 */
#if defined(_WIN32) || defined(_WIN64)
	bool open(SOCKET fd, bool udp_mode = false);
#else
	bool open(int fd, bool udp_mode = false);
#endif

	/**
	 *  ACL_VSTREAM 
	 * @param vstream {ACL_VSTREAM*}
	 * @param udp_mode {bool} Ƿ UDP ʽ
	 * @return {bool} Ƿɹ
	 */
	bool open(ACL_VSTREAM* vstream, bool udp_mode = false);

	/**
	 * Զ̷
	 * @param addr {const char*} ַ, ׽ӿڷ(UNIXƽ̨),
	 *  ׽ӵַ/tmp/test.sockLinux ƽ̨»ӳ׽֣
	 *  abastract unix socketΪͨļ·unix׽ӵַ
	 *   acl й涨ַһֽΪ @Ϊ Linux ׽
	 *  abstract unix domain socketעùܽ Linux ƽ̨֧,
	 *  磺@/tmp/test.sock;
	 *  һTCPַʽΪ: remote_addr[@local_ip],
	 *  : www.sina.com:80@60.28.250.199,
	 *  ˼ǰ󶨱ַΪ: 60.28.250.199, Զ www.sina.com  80,
	 *  OSԶ󶨱 IP ַдΪwww.sina.com:80
	 * @param conn_timeout {int} ӳʱʱ()
	 * @param rw_timeout {int} дʱʱ()
	 * @return {bool} Ƿɹ
	 */
	bool open(const char* addr, int conn_timeout, int rw_timeout);

	/**
	 * 󶨱 UDP ַ UDP 
	 * @param addr {const char*} ַʽip:portõַҲΪ
	 *  UNIX ׽ֻ Linux ׽֣Linux abstract unix socket
	 * @param rw_timeout {int} дʱʱ()
	 * @param flag {unsigned}
	 * @return {bool} Ƿɹ
	 */
	bool bind_udp(const char* addr, int rw_timeout = 0, unsigned flag = 0);

	/**
	 * ر׽ӿڶ
	 * @return {bool}
	 */
	bool shutdown_read(void);

	/**
	 * ر׽ӿд
	 * @return {bool}
	 */
	bool shutdown_write(void);

	/**
	 * ر׽ӿڶд
	 * @return {bool}
	 */
	bool shutdown_readwrite(void);

	/**
	 * ׽Ӿ
	 * @return {ACL_SOCKET} 򷵻 - 1(UNIX ƽ̨)
	 *   INVALID_SOCKET(win32ƽ̨)
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET sock_handle(void) const;
#else
	int   sock_handle(void) const;
#endif

	/**
	 * ׽İ󶨹ϵͬʱ׽ַظû
	 * ׽ֵĹȨûͷʱرո
	 * ֣ûӹܸ׽ֺ뽫ر
	 *  close/open ĵ⣬ĵ(
	 * д)
	 * @return {ACL_SOCKET}  ACL_SOCKET_INVALID ʾ
	 *  Ѿ׽ֽ
	 */
#if defined(_WIN32) || defined(_WIN64)
	SOCKET unbind_sock(void);
#else
	int    unbind_sock(void);
#endif

	/**
	 *  socket 
	 * @return {int} ֵУAF_INET, AF_INT6, AF_UNIXʱ -1
	 */
	int sock_type(void) const;

	/**
	 * Զӵĵַ
	 * @param full {bool} ǷַIP:PORTò
	 *  Ϊ false IP򷵻 IP:PORT
	 * @return {const char*} Զӵֵַ == '\0' ʾ
	 *  ޷Զӵַ
	 */
	const char* get_peer(bool full = false) const;

	/**
	 * Զӵ IP ַ
	 * @return {const char*} Զӵֵַ == '\0' ʾ
	 *  ޷Զӵַ
	 */
	const char* get_peer_ip(void) const;

	/**
	 * ԶӶĵַ TCP ䷽ʽҪʾô˺
	 * Զ̶ַUDP ䷽ʽʱҪô˺Զ̵ַȻ
	 * ſԶд
	 * @param addr {const char*} ԶӶĵַʽip:port
	 * @return {bool} δʱ false
	 */
	bool set_peer(const char* addr);

	/**
	 * ӵıصַ
	 * @param full {bool} ǷַIP:PORTò
	 *  Ϊ false IP򷵻 IP:PORT
	 * @return {const char*} ӵıصֵַ == "" ʾ
	 *  ޷ñصַ
	 */
	const char* get_local(bool full = false) const;

	/**
	 * ӵı IP ַ
	 * @return {const char*} ӵıصֵַ == "" ʾ
	 *  ޷ñصַ
	 */
	const char* get_local_ip(void) const;

	/**
	 * ñصַ
	 * @param addr {const char*} ַʽip:port
	 * @return {bool} δʱ false
	 */
	bool set_local(const char* addr);

	/**
	 * ׽ӿӵĴ״̬(ڲʹ˷ķʽ̽)
	 * @return {bool} δ򿪻Ѿرʱú false
	 *  򷵻 true
	 */
	bool alive(void) const;

	/**
	 *  TCP ׽ֵ nodelay 
	 * @param on {bool} true ʾ򿪣false ʾر
	 * @return {socket_stream&}
	 */
	socket_stream& set_tcp_nodelay(bool on);

	/**
	 *  TCP ׽ֵ SO_LINGER ѡ
	 * @param on {bool} Ƿ SO_LINGER ѡ
	 * @param linger {int} SO_LINGERʱȡ timed_wait ʱ䣬λΪ
	 * @return {socket_stream&}
	 */
	socket_stream& set_tcp_solinger(bool on, int linger);

	/**
	 *  TCP ׽ֵдС
	 * @param size {int} ôС
	 * @return {socket_stream&}
	 */
	socket_stream& set_tcp_sendbuf(int size);

	/**
	 *  TCP ׽ֵĶС
	 * @param size {int} ôС
	 * @return {socket_stream&}
	 */
	socket_stream& set_tcp_recvbuf(int size);

	/**
	 *  TCP ׽ֵķ״̬
	 * @param on {bool} ǷΪ״̬Ϊ true ʱ
	 *  ׽ֱΪ״̬Ϊ״̬
	 * @return {socket_stream&}
	 */
	socket_stream& set_tcp_non_blocking(bool on);

	/**
	 *  TCP ׽Ƿ nodelay ѡ
	 * @return {bool} true ʾ򿪣false ʾر
	 */
	bool get_tcp_nodelay(void);

	/**
	 *  TCP ׽ֵ linger ֵ
	 * @return {int}  -1 ʾδ linger ѡڲ>= 0
	 *  ʾ linger ѡҸֵʾ׽ֹرպ TCP ں
	 *  ά TIME_WAIT ״̬Ķʱ()
	 */
	int get_tcp_solinger(void);

	/**
	 * ȡ TCP ׽ֵдС
	 * @return {int} С
	 */
	int get_tcp_sendbuf(void);

	/**
	 * ȡ TCP ׽ֵĶС
	 * @return {int} С
	 */
	int get_tcp_recvbuf(void);

	/**
	 * жϵǰ׽Ƿ˷ģʽ
	 * @return {bool}
	 * ע÷Ŀǰ֧ UNIX ƽ̨
	 */
	bool get_tcp_non_blocking(void);

private:
	std::string ipbuf_;
	const char* get_ip(const char* addr, std::string& out);
};

} // namespace acl
