#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/string.hpp"
#include "stream_hook.hpp"

struct ACL_VSTREAM;

namespace acl {

class sslbase_conf;
class atomic_long;

class ACL_CPP_API sslbase_io : public stream_hook
{
public:
	/**
	 * 캯
	 * @param conf {sslbase_conf&} ÿһ SSL ӽõ
	 * @param server_side {bool} ǷΪģʽΪͻģʽ
	 *  ģʽַͬͨ˲
	 * @param nblock {bool} ǷΪģʽ
	 */
	sslbase_io(sslbase_conf& conf, bool server_side, bool nblock = false);
	virtual ~sslbase_io(void);

	/**
	 * ssl ִ鷽
	 * @return {bool}
	 */
	virtual bool handshake(void) = 0;

	/**
	 * ׽Ϊģʽ/ģʽ
	 * @param yes {bool} Ϊ false ʱΪģʽΪģʽ
	 */
	void set_non_blocking(bool yes);

	/**
	 * жϵǰõ SSL IO ǷģʽǷģʽ
	 * @return {bool}  true ʾΪģʽΪģʽ
	 */
	bool is_non_blocking(void) const
	{
		return nblock_;
	}

	/**
	 * ж SSL Ƿɹ
	 * @return {bool}
	 */
	bool handshake_ok(void)
	{
		return handshake_ok_;
	}

	/**
	 *  SNI HOST ֶ
	 * @param host {const char*}
	 */
	void set_sni_host(const char* host);

protected:
	sslbase_conf& base_conf_;
	bool server_side_;
	bool nblock_;
	bool handshake_ok_;
	atomic_long* refers_;
	ACL_VSTREAM* stream_;
	string sni_host_;	// just for SNI
};

} // namespace acl
