#pragma once
#include "../acl_cpp_define.hpp"
#include "../stdlib/noncopyable.hpp"

namespace acl {

/**
 *  IO עص࣬ʵָе鷽ͨ setup_hook עᣬ
 * Ȼе IO Ϊ stream/aio_stream ĵײ IO ̱ʹã
 *  stream/aio_stream  setup_hook ע̣ stream/aio_stream
 * ĵײ IO ΪĬϹ
 * XXX ౻ΪѶ࣬ҲӦΪѶ
 */
class ACL_CPP_API stream_hook : public noncopyable
{
public:
	stream_hook(void) {}

	/**
	 * ݽӿ
	 * @param buf {void*} ַݽڸû
	 * @param len {size_t} buf С
	 * @return {int} ֵֽ < 0 ʱʾ
	 */
	virtual int read(void* buf, size_t len) = 0;

	/**
	 * ݽӿ
	 * @param buf {const void*} ͻַ
	 * @param len {size_t} buf ݵĳ( > 0)
	 * @return {int} дݳȣֵ <ʱʾ
	 */
	virtual int send(const void* buf, size_t len) = 0;

	/**
	 *  stream/aio_stream  setup_hook ڲ stream_hook::open
	 * ̣ԱʼһЩݼỰ
	 * @param s {ACL_VSTREAM*}  setup_hook ڲø÷
	 *  Ϊ
	 * @return {bool} ʵ false setup_hook ʧһָԭ
	 */
	virtual bool open(ACL_VSTREAM* s) = 0;

	/**
	 *  stream/aio_stream رǰصúԱʵһЩƺ
	 * @param alive {bool} ǷȻ
	 * @return {bool}
	 */
	virtual bool on_close(bool alive) { (void) alive; return true; }

	/**
	 *  stream/aio_stream Ҫͷ stream_hook ʱô˷
	 */
	virtual void destroy(void) {}

protected:
	virtual ~stream_hook(void) {}
};

} // namespace acl
