#include <iostream>
#include <assert.h>
#include "lib_acl.h"
#include "acl_cpp/acl_cpp_init.hpp"
#include "acl_cpp/stdlib/log.hpp"
#include "acl_cpp/stream/mbedtls_conf.hpp"
#include "acl_cpp/stream/mbedtls_io.hpp"
#include "acl_cpp/stream/polarssl_conf.hpp"
#include "acl_cpp/stream/polarssl_io.hpp"
#include "acl_cpp/stream/aio_handle.hpp"
#include "acl_cpp/stream/aio_istream.hpp"
#include "acl_cpp/stream/aio_listen_stream.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"

static int   __max = 0;
static int   __timeout = 0;
static int   __max_used = 0;
static int   __cur_used = 0;

// SSL ģʽµ SSL ö
static acl::sslbase_conf* __ssl_conf;

/**
 * ӳٶص
 */
class timer_reader: public acl::aio_timer_reader
{
public:
	timer_reader(int delay)
	{
		delay_ = delay;
		printf("timer_reader init, delay: %d\r\n", delay);
	}

protected:
	~timer_reader(void) {}

	// aio_timer_reader  destroy 
	// @override
	void destroy(void)
	{
		printf("timer_reader delete, delay: %d\r\n", delay_);
		delete this;
	}

	// ػص
	// @override
	void timer_callback(unsigned int id)
	{
		printf("timer_reader(%d): delay: %d\r\n", id, delay_);

		// ûĴ
		aio_timer_reader::timer_callback(id);
	}

private:
	int   delay_;
};

/**
 * ӳдص
 */
class timer_writer: public acl::aio_timer_writer
{
public:
	timer_writer(int delay)
	{
		delay_ = delay;
		printf("timer_writer init, delay: %d\r\n", delay);
	}

protected:
	~timer_writer(void) {}

	// aio_timer_reader  destroy 
	// @override
	void destroy(void)
	{
		printf("timer_writer delete, delay: %d\r\n", delay_);
		delete this;
	}

	// ػص
	// @override
	void timer_callback(unsigned int id)
	{
		printf("timer_writer(%d): timer_callback, delay: %d\r\n",
			id, delay_);

		// ûĴ
		aio_timer_writer::timer_callback(id);
	}

private:
	int   delay_;
};

/**
 * 첽ͻĻص
 */
class io_callback : public acl::aio_callback
{
public:
	io_callback(acl::aio_socket_stream* client)
	: client_(client)
	, i_(0) {}

protected:
	~io_callback(void)
	{
		printf("delete io_callback now ...\r\n");
		__cur_used++;
	}

	/**
	 * ص麯ûص aio_istream ʵе
	 * gets/read Ŀɶ󱻵ã첽ڲ
	 * ݶֱӴݸû
	 * @param data {char*} ݵַָ
	 * @param len {int} ݳ(> 0)
	 * @return {bool} ú false ֪ͨ첽رո첽
	 */
	bool read_wakeup(void)
	{
		acl::polarssl_io* hook = (acl::polarssl_io*) client_->get_hook();
		if (hook == NULL) {
			//  SSL ģʽ첽ȡһ
			client_->gets(__timeout, false);
			return true;
		}

		// Խ SSL 
		if (!hook->handshake()) {
			printf("ssl handshake failed\r\n");
			return false;
		}

		//  SSL Ѿɹʼж
		if (hook->handshake_ok()) {
			//  reactor ģʽתΪ proactor ģʽӶȡ
			// read_wakeup ص
			client_->disable_read();

			// 첽ȡһ
			client_->gets(__timeout, false);
			return true;
		}

		// SSL ֻδɣȴٴα
		return true;
	}

	/**
	 * ʵָе麯ͻĶɹص
	 * @param data {char*} ݵַ
	 * @param len {int} ݳ
	 * @return {bool}  true ʾϣرո첽
	 */
	bool read_callback(char* data, int len)
	{
		i_++;
		//if (i_ < 10)
		//	std::cout << ">>gets(i:" << i_ << "): "
		//		<< data << std::endl;

		// Զ̿ͻϣ˳ر֮
		if (!strncasecmp(data, "quit", 4)) {
			client_->format("Bye!\r\n");
			client_->close();
			return true;
		}

		// Զ̿ͻϣҲرգֹ첽¼
		else if (!strncasecmp(data, "stop", 4)) {
			client_->format("Stop now!\r\n");
			client_->close();  // رԶ첽

			// ֪ͨ첽رѭ
			client_->get_handle().stop();
		}

		// Զ̿ͻ˻дյ

		int   delay = 0;

		if (!strncasecmp(data, "write_delay", strlen("write_delay"))) {
			// ӳд

			const char* ptr = data + strlen("write_delay");
			delay = atoi(ptr);
			if (delay > 0) {
				std::cout << ">> write delay " << delay
					<< " second ..." << std::endl;
				timer_writer* timer = new timer_writer(delay);
				client_->write(data, len, delay * 1000000, timer);
				client_->gets(10, false);
				return true;
			}
		} else if (!strncasecmp(data, "read_delay", strlen("read_delay"))) {
			// ӳٶ

			const char* ptr = data + strlen("read_delay");
			delay = atoi(ptr);
			if (delay > 0) {
				client_->write(data, len);
				std::cout << ">> read delay " << delay
					<< " second ..." << std::endl;
				timer_reader* timer = new timer_reader(delay);
				client_->gets(10, false, delay * 1000000, timer);
				return (true);
			}
		}

		client_->write(data, len);
		//client_->gets(10, false);
		return true;
	}

	/**
	 * ʵָе麯ͻдɹص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool write_callback(void)
	{
		return true;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 */
	void close_callback(void)
	{
		// ڴ˴ɾö̬ĻصԷֹڴй¶
		delete this;
	}

	/**
	 * ʵָе麯ͻĳʱص
	 * @return {bool}  true ʾϣرո첽
	 */
	bool timeout_callback(void)
	{
		std::cout << "Timeout, delete it ..." << std::endl;
		return false;
	}

private:
	acl::aio_socket_stream* client_;
	int   i_;
};

/**
 * 첽Ļص
 */
class io_accept_callback : public acl::aio_accept_callback
{
public:
	io_accept_callback(void) {}
	~io_accept_callback(void)
	{
		printf(">>io_accept_callback over!\n");
	}

	/**
	 * 麯ӵô˻ص
	 * @param client {aio_socket_stream*} 첽ͻ
	 * @return {bool}  true ֪ͨ
	 */
	bool accept_callback(acl::aio_socket_stream* client)
	{
		// 첽ͻĻص첽а
		io_callback* callback = new io_callback(client);

		// ע첽Ķص
		client->add_read_callback(callback);

		// ע첽дص
		client->add_write_callback(callback);

		// ע첽Ĺرջص
		client->add_close_callback(callback);

		// ע첽ĳʱص
		client->add_timeout_callback(callback);

		// ޶󳤶ʱ
		if (__max > 0) {
			client->set_buf_max(__max);
		}

		// SSL ģʽ£ȴͻ˷Ϣ
		if (__ssl_conf != NULL) {
			// ע SSL IO ̵Ĺ
			acl::sslbase_io* ssl = __ssl_conf->create(true);

			if (client->setup_hook(ssl) == ssl) {
				std::cout << "setup_hook error" << std::endl;
				ssl->destroy();
				return false;
			}

			// ͻڶ״̬Դ read_wakeup ص̣
			// SSL ֹ̽ read_wakeup 
			client->read_wait(__timeout);
		}

		//  SSL ģʽ£첽һ
		else {
			client->gets(__timeout, false);
		}

		return true;
	}
};

static void usage(const char* procname)
{
	printf("usage: %s -h[help]\r\n"
		" -l server_addr[ip:port, default: 127.0.0.1:9001]\r\n"
		" -S libssl_path\r\n"
		" -L line_max_length\r\n"
		" -t timeout\r\n"
		" -n conn_used_limit\r\n"
		" -k[use kernel event: epoll/iocp/kqueue/devpool]\r\n"
		" -K ssl_key_file -C ssl_cert_file [in SSL mode]\r\n",
		procname);
}

int main(int argc, char* argv[])
{
	// ¼ǷںеĸЧģʽ
	bool use_kernel = false;
	acl::string key_file, cert_file;
	acl::string addr("127.0.0.1:9001"), libssl_path;
	int  ch;

	while ((ch = getopt(argc, argv, "l:hkL:t:K:C:n:S:")) > 0) {
		switch (ch) {
		case 'h':
			usage(argv[0]);
			return 0;
		case 'l':
			addr = optarg;
			break;
		case 'k':
			use_kernel = true;
			break;
		case 'L':
			__max = atoi(optarg);
			break;
		case 't':
			__timeout = atoi(optarg);
			break;
		case 'K':
			key_file = optarg;
			break;
		case 'C':
			cert_file = optarg;
			break;
		case 'n':
			__max_used = atoi(optarg);
			break;
		case 'S':
			libssl_path = optarg;
			break;
		default:
			break;
		}
	}

	// ʼACL(WIN32һҪô˺UNIXƽ̨¿ɲ)
	acl::acl_cpp_init();

	acl::log::stdout_open(true);

	// ˽Կ֤鶼ʱŲ SSL ͨŷʽ
	if (key_file.empty() || cert_file.empty()) {
		/* do nothing */
	} else if (libssl_path.find("mbedtls") != NULL) {
		const std::vector<acl::string>& libs = libssl_path.split2("; \t\r\n");
		if (libs.size() == 3) {
			acl::mbedtls_conf::set_libpath(libs[0], libs[1], libs[2]);
			if (acl::mbedtls_conf::load()) {
				__ssl_conf = new acl::mbedtls_conf(true);
			} else {
				printf("load %s error\r\n", libssl_path.c_str());
			}
		}
	} else if (!libssl_path.empty()) {
		//  libpolarssl.so ȫ·
		acl::polarssl_conf::set_libpath(libssl_path);

		// ̬ libpolarssl.so 
		if (acl::polarssl_conf::load()) {
			__ssl_conf = new acl::polarssl_conf();
		} else {
			printf("load %s error\r\n", libssl_path.c_str());
		}
	}

	if (__ssl_conf) {
		// ˵ SSL Ự湦
		__ssl_conf->enable_cache(true);

		// ӱط֤
		if (!__ssl_conf->add_cert(cert_file.c_str())) {
			delete __ssl_conf;
			__ssl_conf = NULL;
			std::cout << "add_cert error: " << cert_file.c_str()
				<< std::endl;
		}

		// ӱطԿ
		else if (!__ssl_conf->set_key(key_file.c_str())) {
			delete __ssl_conf;
			__ssl_conf = NULL;
			std::cout << "set_key error: " << key_file.c_str()
				<< std::endl;
		} else {
			std::cout << "Load cert&key OK!" << std::endl;
		}
	}

	// 첽
	acl::aio_handle handle(use_kernel ? acl::ENGINE_KERNEL : acl::ENGINE_SELECT);

	// 첽
	acl::aio_listen_stream* sstream = new acl::aio_listen_stream(&handle);

	// ָĵַ
	if (!sstream->open(addr.c_str())) {
		std::cout << "open " << addr.c_str() << " error!" << std::endl;
		sstream->close();
		// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
		handle.check();

		getchar();
		return 1;
	}

	// ص󣬵ӵʱԶôĻص
	io_accept_callback callback;
	sstream->add_accept_callback(&callback);
	std::cout << "Listen: " << addr.c_str() << " ok!" << std::endl;

	while (true) {
		//  false ʾټҪ˳
		if (!handle.check()) {
			std::cout << "aio_server stop now ..." << std::endl;
			break;
		}

		if (__max_used > 0 && __cur_used >= __max_used) {
			break;
		}
	}

	// رռͷ
	sstream->close();

	// XXX: Ϊ˱֤ܹرռӦڴ˴ check һ
	handle.check();

	// ɾ acl::sslbase_conf ̬
	delete __ssl_conf;

	return 0;
}
