#include "acl_stdafx.hpp"
#ifndef ACL_PREPARE_COMPILE
#include "acl_cpp/stream/socket_stream.hpp"
#include "acl_cpp/stream/aio_socket_stream.hpp"
#include "acl_cpp/connpool/connect_monitor.hpp"
#include "acl_cpp/connpool/check_client.hpp"
#endif
#include "check_rpc.hpp"

namespace acl
{

check_rpc::check_rpc(connect_monitor& monitor, check_client& checker)
: monitor_(monitor)
, checker_(checker)
{
}

check_rpc::~check_rpc(void)
{
}

void check_rpc::rpc_run(void)
{
	// 
	socket_stream stream;

	//  get_vstream() õ ACL_VSTREAM 
	//  stream Ϊ acl_cpp  acl е
	// ͷնǻ ACL_VSTREAM ACL_VSTREAM 
	// ڲάһ/дڳӵݴУ
	// ÿν ACL_VSTREAM ΪڲĻԴ
	ACL_VSTREAM* vstream = checker_.get_conn().get_vstream();
	ACL_VSTREAM_SET_RWTIMO(vstream, 10);
	(void) stream.open(vstream);
	// Ϊģʽ
	stream.set_tcp_non_blocking(false);

	// ͬ
	monitor_.sio_check(checker_, stream);

	// Ϊģʽ
	stream.set_tcp_non_blocking(true);

	//  ACL_VSTREAM 󶨣ܱ֤ͷʱ
	// رߵӣΪӱڷģҪ
	// 첽رշʽйر
	stream.unbind();
}

void check_rpc::rpc_onover(void)
{
	// ȡü״̬
	checker_.set_blocked(false);

	// 첽رռ
	checker_.close();

	// ɾ̬ rpc 
	delete this;
}

} // namespace acl
