#ifndef _MSG_INCLUDE_H_
#define _MSG_INCLUDE_H_

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdarg.h>
#include <stdio.h>
#include "define.h"

#undef	USE_PRINTF_MACRO

/**
 * ¼־Ϣ־ļʱҪµ־¼
 */

#ifndef	USE_PRINTF_MACRO

/**
 * һ㼶־Ϣ¼
 * @param fmt {const char*} ʽ
 * @param ... 
 */
void PRINTF(1, 2) msg_info(const char *fmt,...);

/**
 * 漶־Ϣ¼
 * @param fmt {const char*} ʽ
 * @param ... 
 */
void PRINTF(1, 2) msg_warn(const char *fmt,...);

/**
 * 󼶱־Ϣ¼
 * @param fmt {const char*} ʽ
 * @param ... 
 */
void PRINTF(1, 2) msg_error(const char *fmt,...);

/**
 * ־Ϣ¼
 * @param fmt {const char*} ʽ
 * @param ... 
 */
void PRINTF(1, 2) msg_fatal(const char *fmt,...);

#else

/**
 * ¼־Ϣ׼ʱҪµ־¼
 */

#include <stdio.h>

#undef	msg_info
#undef	msg_warn
#undef	msg_error
#undef	msg_fatal

#define	msg_info	msg_printf
#define	msg_warn	msg_printf
#define	msg_error	msg_printf
#define	msg_fatal	msg_printf

#endif

/**
 * ϴϵͳóʱĴϢ
 * @param buffer {char*} 洢Ϣڴ滺
 * @param size {size_t} buffer ĿռС
 * @return {const char*} صĵַӦ buffer ͬ
 */
const char *last_strerror(char *buffer, size_t size);

/**
 * ϴϵͳóʱĴϢúڲֲ߳̾
 * ̰߳ȫģʹЩ
 * @return {const char *} شʾϢ 
 */
const char *last_serror(void);

/**
 * Ϣ׼
 * @param fmt {const char*} ʽ
 * @param ... 
 */
void PRINTF(1, 2) msg_printf(const char *fmt,...);

#ifdef  __cplusplus
}
#endif

#endif
