#ifndef	__LIB_HTTP_UTIL_INCLUDE_H__
#define	__LIB_HTTP_UTIL_INCLUDE_H__

#include "lib_http_struct.h"

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct HTTP_UTIL {
	HTTP_HDR_REQ *hdr_req;		/**< HTTP ͷ */
	HTTP_HDR_RES *hdr_res;		/**< HTTP Ӧͷ */
	HTTP_RES *http_res;		/**< HTTP Ӧ */
	char  server_addr[256];		/**< Զ HTTP ַ */
	ACL_VSTREAM *stream;		/**<  HTTP  */
	int   conn_timeout;		/**<  HTTP ĳʱʱ */
	int   rw_timeout;		/**<  HTTP ͨʱÿ IO ĳʱʱ */
	ACL_VSTRING *req_buf;		/**<  */
	int   res_body_dlen;		/**< HTTP Ӧĳ */
	ACL_VSTREAM *dump_stream;	/**< תݵ */
	unsigned int   flag;		/**< ־λ */
#define	HTTP_UTIL_FLAG_SET_DUMP_FILE	(1 << 0)	/**< תӦļ */
#define	HTTP_UTIL_FLAG_SET_DUMP_STREAM	(1 << 1)	/**< תӦ */
#define	HTTP_UTIL_FLAG_HAS_RES_BODY	(1 << 2)	/**<  HTTP Ӧ */
#define	HTTP_UTIL_FLAG_NO_RES_BODY	(1 << 3)	/**<  HTTP Ӧ */
} HTTP_UTIL;

/**
 * һ HTTP_UTIL 
 * @param url {const char*}  url
 * @param method {const char*} 󷽷Ч󷽷УGET, POST, HEAD, CONNECT
 * @return {HTTP_UTIL*}
 */
HTTP_API HTTP_UTIL *http_util_req_new(const char *url, const char *method);

/**
 * һ HTTP_UTIL Ӧ
 * @param status {int} ״̬룬Ч״̬Ϊ: 1xx, 2xx, 3xx, 4xx, 5xx
 * @return {HTTP_UTIL*}
 */
HTTP_API HTTP_UTIL *http_util_res_new(int status);

/**
 * ͷһ HTTP_UTIL 
 * @param http_util {HTTP_UTIL*}
 */
HTTP_API void http_util_free(HTTP_UTIL *http_util);

/**
 *  HTTP ͷϢ, : Accept-Encoding: gzip,deflate
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ͷֶ,  Accept-Encoding
 * @param value {const char*} ͷֶεֵ,  gzip,deflate
 */
HTTP_API void http_util_set_req_entry(HTTP_UTIL *http_util, const char *name, const char *value);

/**
 * ر HTTP ͷеĳֶΣֶβᷢ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ͷֶ,  Accept-Encoding
 */
HTTP_API void http_util_off_req_entry(HTTP_UTIL *http_util, const char *name);

/**
 * ͷĳֶεֵ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ͷֶ,  Accept-Encoding
 * @return {char*} ǿΪֵֶֶβ
 */
HTTP_API char *http_util_get_req_value(HTTP_UTIL *http_util, const char *name);

/**
 * ͷĳֶε HTTP_HDR_ENTRY 
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ͷֶ,  Accept-Encoding
 * @return {HTTP_HDR_ENTRY*} Ϊʾֶβ
 */
HTTP_API HTTP_HDR_ENTRY *http_util_get_req_entry(HTTP_UTIL *http_util, const char *name);

/**
 * ͷ HTTP ݳ
 * @param http_util {HTTP_UTIL*}
 * @param len {int} HTTP 峤( >= 0)
 */
HTTP_API void http_util_set_req_content_length(HTTP_UTIL *http_util, int len);

/**
 * ͷ HTTP ỰֳӵĴʱ(λΪ)
 * @param http_util {HTTP_UTIL*}
 * @param timeout {int} HTTP ӵĴʱ(λΪ)
 */
HTTP_API void http_util_set_req_keep_alive(HTTP_UTIL *http_util, int timeout);

/**
 * ͷ Connection ֶ
 * @param http_util {HTTP_UTIL*}
 * @param value {const char*} ֵֶЧֶΪ: keep-alive, close
 */
HTTP_API void http_util_set_req_connection(HTTP_UTIL *http_util, const char *value);

/**
 * ͷе Referer ֶ
 * @param http_util {HTTP_UTIL*}
 * @param refer {const char*}  url, : http://www.test.com
 */
HTTP_API void http_util_set_req_refer(HTTP_UTIL *http_util, const char *refer);

/**
 * ͷе Cookie ֶΣõ׷ӷʽ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} Cookie 
 * @param value {const char*} Cookie ֵ
 */
HTTP_API void http_util_set_req_cookie(HTTP_UTIL *http_util, const char *name, const char *value);

/**
 *  HTTP ַ
 * @param http_util {HTTP_UTIL*}
 * @param proxy {const char*} ַЧʽΪ: IP:PORT, DOMAIN:PORT,
 *  : 192.168.0.1:80, 192.168.0.2:8088, www.g.cn:80
 */
HTTP_API void http_util_set_req_proxy(HTTP_UTIL *http_util, const char *proxy);

/**
 *  HTTP Ӧתú HTTP Ӧݱͬʱת
 * @param http_util {HTTP_UTIL*}
 * @param stream {ACL_VSTREAM *} ת
 */
HTTP_API void http_util_set_dump_stream(HTTP_UTIL *http_util, ACL_VSTREAM *stream);

/**
 *  HTTP Ӧתļú HTTP Ӧݱתڸļ
 * @param http_util {HTTP_UTIL*}
 * @param filename {const char*} תļ
 * @return {int} ֵ < 0 ʾ޷򿪸ļ, ʾļɹ
 */
HTTP_API int http_util_set_dump_file(HTTP_UTIL *http_util, const char *filename);

/**
 * Զ HTTP ӣͬʱ HTTP ͷݲҽ
 * ½
 * @param http_util {HTTP_UTIL*}
 * @return {int} 0: ɹ; -1: ޷ӻͷʧ
 */
HTTP_API int http_util_req_open(HTTP_UTIL *http_util);

/**
 *  POST ʱͨ˺ HTTP ,
 * һУԶεñֱ
 * @param http_util {HTTP_UTIL*}
 * @param data {const char*} η͵ݵַǿ
 * @param dlen {size_t} data ݳ,  0
 * @return {int} > 0 ʾγɹ͵; -1: ʾʧ, Ӧ
 *  http_util_free رͷڴԴ
 */
HTTP_API int http_util_put_req_data(HTTP_UTIL *http_util, const char *data, size_t dlen);

/**
 * ݺô˺ HTTP ȡ HTTP Ӧͷ
 * @param http_util {HTTP_UTIL*}
 * @return {int} 0: ɹ; -1: ʧ
 */
HTTP_API int http_util_get_res_hdr(HTTP_UTIL *http_util);

/**
 *  HTTP Ӧͷлĳֵֶ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ֶ,  Content-Length
 * @return {char*} Ӧ name ֵֶ, Ϊʾֶβ
 */
HTTP_API char *http_util_get_res_value(HTTP_UTIL *http_util, const char *name);

/**
 *  HTTP Ӧͷлĳֶζ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ֶ,  Content-Length
 * @return {HTTP_HDR_ENTRY*} Ӧ name ֶζ, Ϊʾֶβ
 */
HTTP_API HTTP_HDR_ENTRY *http_util_get_res_entry(HTTP_UTIL *http_util, const char *name);

/**
 *  HTTP Ӧͷеĳֵֶ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ֶ,  Content-Type
 * @param value {const char*} ֵֶ,  text/html
 */
HTTP_API void http_util_set_res_entry(HTTP_UTIL *http_util, const char *name, const char *value);

/**
 * ر HTTP Ӧͷеĳֶ
 * @param http_util {HTTP_UTIL*}
 * @param name {const char*} ֶ,  Content-Type
 */
HTTP_API void http_util_off_res_entry(HTTP_UTIL *http_util, const char *name);

/**
 *  HTTP Ӧͷô˺жǷ HTTP Ӧ
 * @param http_util {HTTP_UTIL*}
 * @return {int}  0: ʾӦ; !0: ʾӦ
 */
HTTP_API int http_util_has_res_body(HTTP_UTIL *http_util);

/**
 *  HTTP Ӧͷô˺ HTTP ȡ HTTP ݣҪ
 * ˺ֱֵ <= 0, ֮ǰתļתڶȡݹͬʱ
 * һݸתļת
 * @param http_util {HTTP_UTIL*}
 * @param buf {char *} 洢 HTTP ӦĻ
 * @param size {size_t} buf ĿռС
 * @return {int} <= 0: ʾ; > 0: ʾζݳ
 */
HTTP_API int http_util_get_res_body(HTTP_UTIL *http_util, char *buf, size_t size);

/**
 * ĳ url Ӧתĳļ
 * @param url {const char*}  url, : http://www.g.cn
 * @param dump {const char*} תļ
 * @return {int} Ӧݳ, >=0: ʾɹ, -1: ʾʧ
 */
HTTP_API int http_util_dump_url(const char *url, const char *dump);

/**
 * ĳ url Ӧתĳ
 * @param url {const char*}  url, : http://www.g.cn
 * @param stream {ACL_VSTREAM *} ת
 * @return {int} Ӧݳ, >=0: ʾɹ, -1: ʾʧ
 */
HTTP_API int http_util_dump_url_to_stream(const char *url, ACL_VSTREAM *stream);

#ifdef	__cplusplus
}
#endif

#endif
