/*
 * Copyright 2002-2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.taobao.arthas.core.env.convert;

import com.taobao.arthas.core.env.ConversionService;

/**
 * Configuration interface to be implemented by most if not all
 * {@link ConversionService} types. Consolidates the read-only operations
 * exposed by {@link ConversionService} and the mutating operations of
 * {@link ConverterRegistry} to allow for convenient ad-hoc addition and removal
 * of {@link org.springframework.core.convert.converter.Converter Converters}
 * through. The latter is particularly useful when working against a
 * {@link org.springframework.core.env.ConfigurableEnvironment
 * ConfigurableEnvironment} instance in application context bootstrapping code.
 *
 * @author Chris Beams
 * @since 3.1
 * @see com.taobao.arthas.core.env.springframework.core.env.ConfigurablePropertyResolver#getConversionService()
 * @see org.springframework.core.env.ConfigurableEnvironment
 * @see org.springframework.context.ConfigurableApplicationContext#getEnvironment()
 */
public interface ConfigurableConversionService extends ConversionService {

}
