
### Overview

Http API provides a RESTful-like interactive interface, and both
requests and responses data in JSON format. Compared with
Telnet/WebConsole's output unstructured text data, Http API can provide
structured data and support more complex interactive functions, such as
a series of diagnostic operations in specific application scenarios.


#### Access address

The Http API address is: `http://ip:port/api`, the request parameters
must be submitted using `POST`. Such as POST
`http://127.0.0.1:8563/api`.

Note: The telnet port `3658` has compatibility issues with the Chrome
browser. It is recommended to use the http port `8563` to access the
http api.


#### Request data format

```json
{
  "action": "exec",
  "requestId": "req112",
  "sessionId": "94766d3c-8b39-42d3-8596-98aee3ccbefb",
  "consumerId": "955dbd1325334a84972b0f3ac19de4f7_2",
  "command": "version",
  "execTimeout": "10000"
}
```
Request data format description:

* `action` : The requested action/behavior, please refer to "Request
  Actions" for optional values.
*  `requestId` : Optional request ID, generated by the client.
*  `sessionId` : Arthas session ID, one-time command does not need to
   set the session ID.
*  `consumerId` : Arthas consumer ID, used for multi-person sharing
   sessions.
*  `command` : Arthas command line
*  `execTimeout` : Timeout for executing commands (ms), default value is 30000.

Note: Different actions use different parameters. Set the parameters
according to the specific action.

#### Request Actions

Currently supported request actions are as follows:

* `exec` : The command is executed synchronously, and the command
  results is returned after the command execution end or interrupted.
*  `async_exec` : The command is executed asynchronously, and the
   scheduling result of the command is returned immediately. The command
   execution result is obtained through `pull_results` action.
*  `interrupt_job` : To interrupt the foreground command of the session,
   similar to the function of Telnet `Ctrl + c`.
*  `pull_results` : Get the result of the command executed
   asynchronously, and execute it repeatedly in http long-polling mode.
*  `init_session` : Create new session.
*  `join_session` : Join the session, used to support multiple people
   sharing the same Arthas session.
*  `close_session` : Close the session.

#### Response status

The state attribute in the response indicates the request processing
state, and its value is as follows:

* `SCHEDULED`: When the command is executed asynchronously, it means that
  the job has been created, and may not be executed yet or is being
  executed;
* `SUCCEEDED`: The request is processed successfully (completed status);
* `FAILED`: Request processing failed (completed status), usually
  accompanied by a message explaining the reason;
* `REFUSED`: The request is rejected (completed status), usually
  accompanied by a message explaining the reason; 
