/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import sun.nio.ch.FileChannelImpl;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final ThreadLocal<Boolean> runningFinalize = new ThreadLocal();

    private static boolean isRunningFinalize() {
        Boolean bl = runningFinalize.get();
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.fd.incrementAndGetUseCount();
        this.open(string);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
        this.fd.incrementAndGetUseCount();
    }

    private native void open(String var1) throws FileNotFoundException;

    public native int read() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public native long skip(long var1) throws IOException;

    public native int available() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int n;
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.fd.decrementAndGetUseCount();
            this.channel.close();
        }
        if ((n = this.fd.decrementAndGetUseCount()) <= 0 || !FileInputStream.isRunningFinalize()) {
            this.close0();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open((FileDescriptor)this.fd, (boolean)true, (boolean)false, (Object)this);
                this.fd.incrementAndGetUseCount();
            }
            return this.channel;
        }
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            runningFinalize.set(Boolean.TRUE);
            try {
                this.close();
                Object var2_1 = null;
                runningFinalize.set(Boolean.FALSE);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                runningFinalize.set(Boolean.FALSE);
                throw throwable;
            }
        }
    }

    static {
        FileInputStream.initIDs();
    }
}

