/*
 * Decompiled with CFR 0.152.
 */
package com.bangcle.signer;

import com.bangcle.signer.LocalStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class main {
    protected Shell shell;
    private Composite mTopComposite;
    private Text mProjectText;
    private Composite mErrorComposite;
    private Label mUseExistingKeystore;
    private Text mKeystore;
    private Text mKeystorePassword;
    private Label mKeyAliasesLabel;
    private Combo mKeyAliases;
    private Label mKeyPasswordLabel;
    private Text mKeyPassword;
    private Text mDestination;
    private Label mDestinationMsg;

    public static void main(String[] args) {
        try {
            main window = new main();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContents() {
        this.shell = new Shell();
        this.shell.setSize(600, 400);
        Image image = null;
        try {
            image = new Image((Device)Display.getCurrent(), "./jar/icon.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.shell.setImage(image);
        this.shell.setText("Bangcle Signer");
        this.shell.setLayout(new GridLayout());
        GridLayout gl = null;
        GridData gd = null;
        this.mTopComposite = new Composite(this.shell, 0);
        this.mTopComposite.setLayoutData(new GridData(1808));
        this.mTopComposite.setLayout(new GridLayout(1, false));
        Composite projectComposite = new Composite(this.mTopComposite, 0);
        projectComposite.setLayoutData(new GridData(768));
        gl = new GridLayout(3, false);
        projectComposite.setLayout(gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Label label = new Label(projectComposite, 0);
        gd = new GridData(768);
        label.setLayoutData(gd);
        gd.horizontalSpan = 3;
        label.setText("Select the unsigned APK to sign:");
        new Label(projectComposite, 0).setText("APK:");
        this.mProjectText = new Text(projectComposite, 2048);
        gd = new GridData(768);
        this.mProjectText.setLayoutData(gd);
        this.mProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalStore.setApkPath(main.this.mProjectText.getText().trim());
            }
        });
        final Button browseButton = new Button(projectComposite, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(browseButton.getShell(), 4096);
                fileDialog.setText("Select an unsigned apk");
                String fileName = fileDialog.open();
                if (fileName != null) {
                    main.this.mProjectText.setText(fileName);
                    if (main.this.mDestination != null) {
                        int dotIndex = fileName.lastIndexOf(".");
                        String name = fileName.substring(0, dotIndex);
                        System.out.println(name);
                        main.this.mDestination.setText(String.valueOf(name) + "_signed.apk");
                    }
                }
            }
        });
        Composite composite = new Composite(this.shell, 0);
        composite.setLayoutData(new GridData(1808));
        GridLayout gl2 = new GridLayout(3, false);
        composite.setLayout(gl2);
        this.mUseExistingKeystore = new Label(composite, 0);
        this.mUseExistingKeystore.setText("Use existing keystore");
        GridData gd2 = new GridData(768);
        this.mUseExistingKeystore.setLayoutData(gd2);
        gd2.horizontalSpan = 3;
        new Label(composite, 0).setText("Location:");
        this.mKeystore = new Text(composite, 2048);
        gd2 = new GridData(768);
        this.mKeystore.setLayoutData(gd2);
        final Button browseButton2 = new Button(composite, 8);
        browseButton2.setText("Browse...");
        browseButton2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(browseButton2.getShell(), 4096);
                fileDialog.setText("Load Keystore");
                String fileName = fileDialog.open();
                if (fileName != null) {
                    main.this.mKeystore.setText(fileName);
                    if (main.this.mKeystorePassword != null) {
                        main.this.mKeystorePassword.setText("");
                    }
                }
            }
        });
        new Label(composite, 0).setText("Password:");
        this.mKeystorePassword = new Text(composite, 0x400800);
        gd2 = new GridData(768);
        this.mKeystorePassword.setLayoutData(gd2);
        gd2 = new GridData();
        new Composite(composite, 0).setLayoutData(gd2);
        gd2.widthHint = 0;
        gd2.heightHint = 0;
        this.mKeyAliasesLabel = new Label(composite, 0);
        this.mKeyAliasesLabel.setText("Alias:");
        this.mKeyAliases = new Combo(composite, 8);
        this.mKeyAliases.setLayoutData(new GridData(768));
        this.mKeyAliasesLabel.setEnabled(false);
        this.mKeyAliases.setEnabled(false);
        gd = new GridData();
        new Composite(composite, 0).setLayoutData(gd);
        gd.heightHint = 0;
        gd.widthHint = 50;
        this.mKeyPasswordLabel = new Label(composite, 0);
        this.mKeyPasswordLabel.setText("Password:");
        this.mKeyPassword = new Text(composite, 0x400800);
        this.mKeyPassword.setLayoutData(new GridData(768));
        this.mKeyPassword.setEnabled(false);
        this.mKeyPasswordLabel.setEnabled(false);
        this.mKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalStore.setKeystorePath(main.this.mKeystore.getText().trim());
                main.this.onChange();
            }
        });
        this.mKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalStore.setKeystorePassword(main.this.mKeystorePassword.getText());
                main.this.onChange();
            }
        });
        this.mKeyAliases.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalStore.setKeyAlias(main.this.mKeyAliases.getItem(main.this.mKeyAliases.getSelectionIndex()));
                main.this.mKeyPassword.setText("");
            }
        });
        this.mKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalStore.setKeyPassword(main.this.mKeyPassword.getText());
            }
        });
        Composite composite3 = new Composite(this.shell, 0);
        composite3.setLayoutData(new GridData(1808));
        GridLayout gl3 = new GridLayout(3, false);
        composite3.setLayout(gl3);
        this.mDestinationMsg = new Label(composite3, 0);
        this.mDestinationMsg.setText("Enter destination for the APK file.");
        GridData gd3 = new GridData(768);
        this.mDestinationMsg.setLayoutData(gd3);
        gd3.horizontalSpan = 3;
        new Label(composite3, 0).setText("Destination APK file:");
        this.mDestination = new Text(composite3, 2048);
        gd3 = new GridData(768);
        this.mDestination.setLayoutData(gd3);
        this.mDestination.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                main.this.onDestinationChange();
            }
        });
        final Button browseButton3 = new Button(composite3, 8);
        browseButton3.setText("Browse...");
        new Label(composite3, 0);
        new Label(composite3, 0);
        browseButton3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(browseButton3.getShell(), 8192);
                fileDialog.setText("Destination file name");
                String saveLocation = fileDialog.open();
                if (saveLocation != null) {
                    main.this.mDestination.setText(saveLocation);
                }
            }
        });
        final ProgressBar pb2 = new ProgressBar(this.shell, 258);
        pb2.setLayoutData(new GridData(768));
        pb2.setVisible(false);
        final Button OkButton = new Button(this.shell, 0x1000000);
        OkButton.setText("Sign Now");
        GridData gd4 = new GridData(64);
        OkButton.setLayoutData(gd4);
        OkButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(final SelectionEvent e) {
                System.out.println("Thread1 = " + Thread.currentThread().getName());
                if (LocalStore.APK_PATH.equals("") || LocalStore.KEYSTORE_PATH.equals("") || LocalStore.KEYSTORE_PWD.equals("") || LocalStore.KEY_ALIAS.equals("") || LocalStore.KEY_PWD.equals("") || LocalStore.DESTINATION.equals("")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            int style = 65600;
                            MessageBox messageBox = new MessageBox((this).main.this.shell, style);
                            messageBox.setText("Error");
                            messageBox.setMessage("You should fill in all the blanks before signing!");
                            e.doit = messageBox.open() == 64;
                        }
                    });
                    return;
                }
                pb2.setVisible(true);
                OkButton.setEnabled(false);
                Thread t = new Thread(){

                    public void run() {
                        System.out.println("Thread2 = " + Thread.currentThread().getName());
                        Runtime rn = Runtime.getRuntime();
                        Process proc = null;
                        String exeFile = "cmd /c .\\java1.6.0\\bin\\jarsigner.exe -verbose -keystore " + LocalStore.KEYSTORE_PATH.replace(" ", "\" \"") + " -storepass " + "\"" + LocalStore.KEYSTORE_PWD + "\"" + " -keypass " + "\"" + LocalStore.KEY_PWD + "\"" + " -signedjar " + LocalStore.DESTINATION.replace(" ", "\" \"") + " " + LocalStore.APK_PATH.replace(" ", "\" \"") + " " + "\"" + LocalStore.KEY_ALIAS + "\"";
                        System.out.println("Sign cmd = " + exeFile);
                        try {
                            proc = rn.exec(exeFile);
                            InputStream stdin = proc.getInputStream();
                            InputStreamReader isr = new InputStreamReader(stdin);
                            BufferedReader br = new BufferedReader(isr);
                            String line = null;
                            System.out.println("<OUTPUT>");
                            while ((line = br.readLine()) != null) {
                                System.out.println(line);
                            }
                            System.out.println("</OUTPUT>");
                            final int exitVal = proc.waitFor();
                            System.out.println("Process exitValue: " + exitVal);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    int style = 65600;
                                    MessageBox messageBox = new MessageBox(((this).this).main.this.shell, style);
                                    messageBox.setText("Sign status");
                                    if (exitVal == 0) {
                                        messageBox.setMessage("Sign success!");
                                    } else {
                                        messageBox.setMessage("Sign fail!");
                                    }
                                    e.doit = messageBox.open() == 64;
                                }
                            });
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            System.out.println("error = " + e1.getMessage());
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                pb2.setVisible(false);
                                OkButton.setEnabled(true);
                            }
                        });
                    }
                };
                t.start();
            }
        });
    }

    private void onChange() {
        if (this.mKeystore.getText().trim().length() > 0 && this.mKeystorePassword.getText().length() > 0) {
            try {
                this.mKeyAliases.removeAll();
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream fis = new FileInputStream(LocalStore.KEYSTORE_PATH);
                keyStore.load(fis, LocalStore.KEYSTORE_PWD.toCharArray());
                fis.close();
                Enumeration<String> aliases = keyStore.aliases();
                int count = 0;
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    this.mKeyAliases.add(alias);
                    ++count;
                }
                if (count != 0) {
                    this.mKeyAliasesLabel.setEnabled(true);
                    this.mKeyAliases.setEnabled(true);
                    this.mKeyPassword.setEnabled(true);
                    this.mKeyPasswordLabel.setEnabled(true);
                    this.mKeyAliases.select(0);
                    LocalStore.setKeyAlias(this.mKeyAliases.getItem(0));
                } else {
                    this.mKeyAliasesLabel.setEnabled(false);
                    this.mKeyAliases.setEnabled(false);
                    this.mKeyPassword.setEnabled(false);
                    this.mKeyPasswordLabel.setEnabled(false);
                }
                this.mKeyPassword.setText("");
            }
            catch (KeyStoreException e) {
                System.out.println(e.getMessage());
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println(e.getMessage());
            }
            catch (CertificateException e) {
                System.out.println(e.getMessage());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else {
            this.mKeyAliasesLabel.setEnabled(false);
            this.mKeyAliases.setEnabled(false);
            this.mKeyPassword.setEnabled(false);
            this.mKeyPasswordLabel.setEnabled(false);
        }
    }

    private void onDestinationChange() {
        this.setMessage("");
        String path = this.mDestination.getText().trim();
        if (path.length() == 0) {
            this.setMessage("Enter destination for the APK file.");
            LocalStore.DESTINATION = "";
            return;
        }
        File file = new File(path);
        if (file.isDirectory()) {
            this.setMessage("ERROR: Destination is a directory.");
            LocalStore.DESTINATION = "";
            return;
        }
        File parentFolder = file.getParentFile();
        if (parentFolder == null || !parentFolder.isDirectory()) {
            this.setMessage("ERROR: Not a valid directory.");
            LocalStore.DESTINATION = "";
            return;
        }
        boolean fileExists = false;
        if (file.isFile()) {
            fileExists = true;
        } else {
            this.setMessage(path);
        }
        LocalStore.setDestinationName(this.mDestination.getText());
        if (fileExists) {
            this.setMessage("WARNING: A destination file already exists.");
        }
    }

    private void setMessage(String msg) {
        this.mDestinationMsg.setText(msg);
    }
}

