/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.PowerPackerFile;
import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ModfileInputStream
extends RandomAccessInputStreamImpl {
    private String fileName;

    public ModfileInputStream(File file) throws FileNotFoundException, IOException {
        super(file);
        this.fileName = file.getAbsolutePath();
        this.checkForPowerPackerFile();
    }

    public ModfileInputStream(String string) throws FileNotFoundException, IOException {
        super(string);
        this.fileName = string;
        this.checkForPowerPackerFile();
    }

    public ModfileInputStream(URL uRL) throws IOException, FileNotFoundException, MalformedURLException {
        super(uRL);
        this.fileName = Helpers.createLocalFileStringFromURL(uRL, false);
        this.checkForPowerPackerFile();
    }

    public String getFileName() {
        return this.fileName;
    }

    private void checkForPowerPackerFile() {
        try {
            if (PowerPackerFile.isPowerPacker(this)) {
                PowerPackerFile powerPackerFile = new PowerPackerFile(this);
                this.close();
                this.tmpFile = null;
                this.raFile = null;
                this.buffer = powerPackerFile.getBuffer();
                this.bufferLength = this.buffer.length;
                this.readPointer = 0;
            }
        }
        catch (IOException iOException) {
            Log.error("ModfileInputStream::checkForPowerPackerFile", iOException);
        }
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.read(byArray, 0, n);
        return Helpers.retrieveAsString(byArray, 0, n2);
    }

    public int readByteAsInt() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readMotorolaWord() throws IOException {
        return (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8;
    }

    public int readMotorolaDWord() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelDWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }
}

