/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.multimedia.flac;

import de.quippy.javamod.io.FileOrPackedInputStream;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.flac.FLACInfoPanel;
import de.quippy.javamod.multimedia.flac.FLACMixer;
import de.quippy.javamod.system.Log;
import de.quippy.jflac.FLACDecoder;
import de.quippy.jflac.metadata.VorbisComment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;
import javax.swing.JPanel;

public class FLACContainer
extends MultimediaContainer {
    private static final String[] FLACFILEEXTENSION = new String[]{"flac"};
    private JPanel flacInfoPanel;
    private VorbisComment vorbisComment;

    static {
        MultimediaContainerManager.registerContainer(new FLACContainer());
    }

    @Override
    public boolean canExport() {
        return true;
    }

    @Override
    public MultimediaContainer getInstance(URL uRL) {
        MultimediaContainer multimediaContainer = super.getInstance(uRL);
        FileOrPackedInputStream fileOrPackedInputStream = null;
        try {
            try {
                fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
                FLACDecoder fLACDecoder = new FLACDecoder(fileOrPackedInputStream);
                fLACDecoder.readMetadata();
                this.vorbisComment = fLACDecoder.getVorbisComment();
                AudioFormat audioFormat = fLACDecoder.getStreamInfo().getAudioFormat();
                long l = (long)audioFormat.getSampleRate();
                long l2 = fLACDecoder.getStreamInfo().getTotalSamples() * 1000L / l;
                ((FLACInfoPanel)this.getInfoPanel()).fillInfoPanelWith(audioFormat, l2, this.getSongName(), fLACDecoder.getVorbisComment());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            if (fileOrPackedInputStream != null) {
                try {
                    ((InputStream)fileOrPackedInputStream).close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
        return multimediaContainer;
    }

    private String getSongName(VorbisComment vorbisComment, URL uRL) {
        if (vorbisComment != null) {
            try {
                String string = vorbisComment.getArtist();
                String string2 = vorbisComment.getTitle();
                if (string2 == null || string2.length() == 0) {
                    string2 = MultimediaContainerManager.getSongNameFromURL(uRL);
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (string != null && string.length() != 0) {
                    stringBuilder.append(string).append(" - ");
                }
                return stringBuilder.append(string2).toString();
            }
            catch (Throwable throwable) {}
        }
        return MultimediaContainerManager.getSongNameFromURL(uRL);
    }

    @Override
    public String getSongName() {
        if (this.vorbisComment != null) {
            return this.getSongName(this.vorbisComment, this.getFileURL());
        }
        return super.getSongName();
    }

    @Override
    public Mixer createNewMixer() {
        return new FLACMixer(this.getFileURL());
    }

    @Override
    public Object[] getSongInfosFor(URL uRL) {
        Long l;
        String string;
        block14: {
            string = MultimediaContainerManager.getSongNameFromURL(uRL);
            l = -1L;
            FileOrPackedInputStream fileOrPackedInputStream = null;
            try {
                try {
                    fileOrPackedInputStream = new FileOrPackedInputStream(uRL);
                    FLACDecoder fLACDecoder = new FLACDecoder(fileOrPackedInputStream);
                    fLACDecoder.readMetadata();
                    VorbisComment vorbisComment = fLACDecoder.getVorbisComment();
                    string = this.getSongName(vorbisComment, uRL);
                    AudioFormat audioFormat = fLACDecoder.getStreamInfo().getAudioFormat();
                    long l2 = (long)audioFormat.getSampleRate();
                    l = fLACDecoder.getStreamInfo().getTotalSamples() * 1000L / l2;
                }
                catch (Throwable throwable) {
                    if (fileOrPackedInputStream != null) {
                        try {
                            ((InputStream)fileOrPackedInputStream).close();
                        }
                        catch (IOException iOException) {
                            Log.error("IGNORED", iOException);
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileOrPackedInputStream != null) {
                    try {
                        ((InputStream)fileOrPackedInputStream).close();
                    }
                    catch (IOException iOException) {
                        Log.error("IGNORED", iOException);
                    }
                }
                throw throwable;
            }
            if (fileOrPackedInputStream != null) {
                try {
                    ((InputStream)fileOrPackedInputStream).close();
                }
                catch (IOException iOException) {
                    Log.error("IGNORED", iOException);
                }
            }
        }
        return new Object[]{string, l};
    }

    @Override
    public String getName() {
        return "FLAC-File";
    }

    @Override
    public String[] getFileExtensionList() {
        return FLACFILEEXTENSION;
    }

    @Override
    public JPanel getConfigPanel() {
        return null;
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.flacInfoPanel == null) {
            this.flacInfoPanel = new FLACInfoPanel();
        }
        return this.flacInfoPanel;
    }

    @Override
    public void configurationChanged(Properties properties) {
    }

    @Override
    public void configurationSave(Properties properties) {
    }
}

