/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jflac.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomFileInputStream
extends InputStream {
    protected RandomAccessFile randomFile = null;

    public RandomFileInputStream(File file) throws FileNotFoundException {
        this.randomFile = new RandomAccessFile(file, "r");
    }

    public RandomFileInputStream(String string) throws FileNotFoundException {
        this.randomFile = new RandomAccessFile(string, "r");
    }

    public RandomFileInputStream(RandomAccessFile randomAccessFile) {
        this.randomFile = randomAccessFile;
    }

    @Override
    public int read() throws IOException {
        return this.randomFile.read();
    }

    @Override
    public synchronized void reset() {
        System.out.println("RandomFileInputStream: reset");
    }

    @Override
    public void close() throws IOException {
        this.randomFile.close();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        System.out.println("RandomFileInputStream: mark");
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.randomFile.getFilePointer();
        this.randomFile.seek(l2 + l);
        return this.randomFile.getFilePointer() - l2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.randomFile.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.randomFile.read(byArray, n, n2);
    }

    public void seek(long l) throws IOException {
        this.randomFile.seek(l);
    }
}

