/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.info;

import de.quippy.jmac.info.APETagField;
import de.quippy.jmac.info.APETagFooter;
import de.quippy.jmac.info.ID3Genre;
import de.quippy.jmac.info.ID3Tag;
import de.quippy.jmac.tools.ByteArrayReader;
import de.quippy.jmac.tools.File;
import de.quippy.jmac.tools.JMACException;
import de.quippy.jmac.tools.RandomAccessFile;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class APETag
implements Comparator<APETagField> {
    public static final String APE_TAG_FIELD_TITLE = "Title";
    public static final String APE_TAG_FIELD_ARTIST = "Artist";
    public static final String APE_TAG_FIELD_ALBUM = "Album";
    public static final String APE_TAG_FIELD_COMMENT = "Comment";
    public static final String APE_TAG_FIELD_YEAR = "Year";
    public static final String APE_TAG_FIELD_TRACK = "Track";
    public static final String APE_TAG_FIELD_GENRE = "Genre";
    public static final String APE_TAG_FIELD_COVER_ART_FRONT = "Cover Art (front)";
    public static final String APE_TAG_FIELD_NOTES = "Notes";
    public static final String APE_TAG_FIELD_LYRICS = "Lyrics";
    public static final String APE_TAG_FIELD_COPYRIGHT = "Copyright";
    public static final String APE_TAG_FIELD_BUY_URL = "Buy URL";
    public static final String APE_TAG_FIELD_ARTIST_URL = "Artist URL";
    public static final String APE_TAG_FIELD_PUBLISHER_URL = "Publisher URL";
    public static final String APE_TAG_FIELD_FILE_URL = "File URL";
    public static final String APE_TAG_FIELD_COPYRIGHT_URL = "Copyright URL";
    public static final String APE_TAG_FIELD_MJ_METADATA = "Media Jukebox Metadata";
    public static final String APE_TAG_FIELD_TOOL_NAME = "Tool Name";
    public static final String APE_TAG_FIELD_TOOL_VERSION = "Tool Version";
    public static final String APE_TAG_FIELD_PEAK_LEVEL = "Peak Level";
    public static final String APE_TAG_FIELD_REPLAY_GAIN_RADIO = "Replay Gain (radio)";
    public static final String APE_TAG_FIELD_REPLAY_GAIN_ALBUM = "Replay Gain (album)";
    public static final String APE_TAG_FIELD_COMPOSER = "Composer";
    public static final String APE_TAG_FIELD_KEYWORDS = "Keywords";
    public static final int APE_TAG_FLAG_CONTAINS_HEADER = Integer.MIN_VALUE;
    public static final int APE_TAG_FLAG_CONTAINS_FOOTER = 0x40000000;
    public static final int APE_TAG_FLAG_IS_HEADER = 0x20000000;
    public static final int APE_TAG_FLAGS_DEFAULT = 0x40000000;
    public static final String APE_TAG_GENRE_UNDEFINED = "Undefined";
    private File m_spIO;
    private boolean m_bAnalyzed = false;
    private int m_nTagBytes = 0;
    private List<APETagField> m_aryFields = new ArrayList<APETagField>();
    private boolean m_bHasAPETag;
    private int m_nAPETagVersion;
    private boolean m_bHasID3Tag;
    private boolean m_bIgnoreReadOnly = false;
    private APETagFooter m_footer = null;

    public APETag(File file) throws IOException {
        this(file, true);
    }

    public APETag(File file, boolean bl) throws IOException {
        this.m_spIO = file;
        if (bl) {
            this.Analyze();
        }
    }

    public APETag(String string) throws IOException {
        this(string, true);
    }

    public APETag(String string, boolean bl) throws IOException {
        this.m_spIO = new RandomAccessFile(new java.io.File(string), "r");
        if (bl) {
            this.Analyze();
        }
    }

    public void SetFieldString(String string, String string2) throws IOException {
        if (string2 == null || string2.length() <= 0) {
            this.RemoveField(string);
        } else {
            byte[] byArray = string2.getBytes("UTF-8");
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.SetFieldBinary(string, byArray2, 0);
        }
    }

    public void SetFieldBinary(String string, byte[] byArray, int n) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (string == null) {
            return;
        }
        boolean bl = byArray == null || byArray.length <= 0;
        int n2 = this.GetTagFieldIndex(string);
        if (n2 >= 0) {
            if (!this.m_bIgnoreReadOnly && this.m_aryFields.get(n2).GetIsReadOnly()) {
                return;
            }
            if (bl) {
                this.RemoveField(n2);
            }
            this.m_aryFields.set(n2, new APETagField(string, byArray, n));
        } else {
            if (bl) {
                return;
            }
            this.m_aryFields.add(new APETagField(string, byArray, n));
        }
    }

    public byte[] GetFieldBinary(String string) throws IOException {
        APETagField aPETagField;
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if ((aPETagField = this.GetTagField(string)) == null) {
            return null;
        }
        return aPETagField.GetFieldValue();
    }

    public String GetFieldString(String string) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        String string2 = null;
        APETagField aPETagField = this.GetTagField(string);
        if (aPETagField != null) {
            byte[] byArray = aPETagField.GetFieldValue();
            int n = 0;
            int n2 = byArray.length - 1;
            while (n2 >= 0 && byArray[n2] == 0) {
                --n2;
                --n;
            }
            string2 = n2 < 0 ? "" : (aPETagField.GetIsUTF8Text() || this.m_nAPETagVersion < 2000 ? (this.m_nAPETagVersion >= 2000 ? new String(byArray, 0, byArray.length + n, "UTF-8") : new String(byArray, 0, byArray.length + n, "US-ASCII")) : new String(byArray, 0, byArray.length + n, "UTF-16"));
        }
        return string2;
    }

    public void RemoveField(String string) throws IOException {
        this.RemoveField(this.GetTagFieldIndex(string));
    }

    public void RemoveField(int n) {
        this.m_aryFields.remove(n);
    }

    public void ClearFields() {
        this.m_aryFields.clear();
    }

    public int GetTagBytes() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_nTagBytes;
    }

    public boolean GetHasID3Tag() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_bHasID3Tag;
    }

    public boolean GetHasAPETag() throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        return this.m_bHasAPETag;
    }

    public int GetAPETagVersion() throws IOException {
        return this.GetHasAPETag() ? this.m_nAPETagVersion : -1;
    }

    public APETagField GetTagField(String string) throws IOException {
        int n = this.GetTagFieldIndex(string);
        return n != -1 ? this.m_aryFields.get(n) : null;
    }

    public APETagField GetTagField(int n) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (n >= 0 && n < this.m_aryFields.size()) {
            return this.m_aryFields.get(n);
        }
        return null;
    }

    public void SetIgnoreReadOnly(boolean bl) {
        this.m_bIgnoreReadOnly = bl;
    }

    public void CreateID3Tag(ID3Tag iD3Tag) throws IOException {
        if (iD3Tag == null) {
            return;
        }
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (this.m_aryFields.size() <= 0) {
            return;
        }
        iD3Tag.Header = "TAG";
        iD3Tag.Artist = this.GetFieldID3String(APE_TAG_FIELD_ARTIST);
        iD3Tag.Album = this.GetFieldID3String(APE_TAG_FIELD_ALBUM);
        iD3Tag.Title = this.GetFieldID3String(APE_TAG_FIELD_TITLE);
        iD3Tag.Comment = this.GetFieldID3String(APE_TAG_FIELD_COMMENT);
        iD3Tag.Year = this.GetFieldID3String(APE_TAG_FIELD_YEAR);
        String string = this.GetFieldString(APE_TAG_FIELD_TRACK);
        try {
            iD3Tag.Track = Short.parseShort(string);
        }
        catch (Exception exception) {
            iD3Tag.Track = (short)255;
        }
        iD3Tag.Genre = (short)new ID3Genre(this.GetFieldString(APE_TAG_FIELD_GENRE)).getGenre();
    }

    private void Analyze() throws IOException {
        this.ClearFields();
        this.m_nTagBytes = 0;
        this.m_bAnalyzed = true;
        long l = this.m_spIO.getFilePointer();
        this.m_bHasID3Tag = false;
        this.m_bHasAPETag = false;
        this.m_nAPETagVersion = -1;
        ID3Tag iD3Tag = ID3Tag.read(this.m_spIO);
        if (iD3Tag != null) {
            this.m_bHasID3Tag = true;
            this.m_nTagBytes += 128;
        }
        if (this.m_bHasID3Tag && iD3Tag != null) {
            this.SetFieldID3String(APE_TAG_FIELD_ARTIST, iD3Tag.Artist);
            this.SetFieldID3String(APE_TAG_FIELD_ALBUM, iD3Tag.Album);
            this.SetFieldID3String(APE_TAG_FIELD_TITLE, iD3Tag.Title);
            this.SetFieldID3String(APE_TAG_FIELD_COMMENT, iD3Tag.Comment);
            this.SetFieldID3String(APE_TAG_FIELD_YEAR, iD3Tag.Year);
            this.SetFieldString(APE_TAG_FIELD_TRACK, String.valueOf(iD3Tag.Track));
            if (iD3Tag.Genre == 255 || iD3Tag.Genre >= ID3Genre.genreCount()) {
                this.SetFieldString(APE_TAG_FIELD_GENRE, APE_TAG_GENRE_UNDEFINED);
            } else {
                this.SetFieldString(APE_TAG_FIELD_GENRE, ID3Genre.genreString(iD3Tag.Genre));
            }
        }
        if (!this.m_bHasID3Tag) {
            this.m_footer = APETagFooter.read(this.m_spIO);
            if (this.m_footer != null && this.m_footer.GetIsValid(false)) {
                this.m_bHasAPETag = true;
                this.m_nAPETagVersion = this.m_footer.GetVersion();
                int n = this.m_footer.GetFieldBytes();
                this.m_nTagBytes += this.m_footer.GetTotalTagBytes();
                this.m_spIO.seek(this.m_spIO.length() - (long)this.m_footer.GetTotalTagBytes() - (long)this.m_footer.GetFieldsOffset());
                try {
                    ByteArrayReader byteArrayReader = new ByteArrayReader(this.m_spIO, n);
                    int n2 = 0;
                    while (n2 < this.m_footer.GetNumberFields()) {
                        this.LoadField(byteArrayReader);
                        ++n2;
                    }
                }
                catch (EOFException eOFException) {
                    throw new JMACException("Can't Read APE Tag Fields");
                }
            }
        }
        this.m_spIO.seek(l);
    }

    private int GetTagFieldIndex(String string) throws IOException {
        if (!this.m_bAnalyzed) {
            this.Analyze();
        }
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_aryFields.size()) {
            if (string.toLowerCase().equals(this.m_aryFields.get(n).GetFieldName().toLowerCase())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void LoadField(ByteArrayReader byteArrayReader) throws IOException {
        int n = byteArrayReader.readInt();
        int n2 = byteArrayReader.readInt();
        String string = byteArrayReader.readString("UTF-8");
        byte[] byArray = new byte[n];
        byteArrayReader.readFully(byArray);
        this.SetFieldBinary(string, byArray, n2);
    }

    @Override
    public int compare(APETagField aPETagField, APETagField aPETagField2) {
        return aPETagField.GetFieldSize() - aPETagField2.GetFieldSize();
    }

    private String GetFieldID3String(String string) throws IOException {
        return this.GetFieldString(string);
    }

    private void SetFieldID3String(String string, String string2) throws IOException {
        this.SetFieldString(string, string2.trim());
    }

    public APETagFooter getFooter() {
        return this.m_footer;
    }
}

