/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.jmac.tools;

import de.quippy.jmac.tools.JMACException;
import java.io.UnsupportedEncodingException;

public class ByteArrayWriter {
    private byte[] data = null;
    private int index = 0;

    public ByteArrayWriter() {
    }

    public ByteArrayWriter(int n) {
        this.data = new byte[n];
    }

    public ByteArrayWriter(byte[] byArray) {
        this.data = byArray;
    }

    public void reset(int n) {
        this.data = new byte[n];
        this.index = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void writeUnsignedByte(short s) {
        if (s < 0 || s > 255) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)s;
    }

    public void writeUnsignedShort(int n) {
        if (n < 0 || n > 65535) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)(n & 0xFF);
        this.data[this.index++] = (byte)(n >> 8);
    }

    public void writeUnsignedInt(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new JMACException("Wrong Value");
        }
        this.data[this.index++] = (byte)(l & 0xFFL);
        this.data[this.index++] = (byte)(l >> 8 & 0xFFL);
        this.data[this.index++] = (byte)(l >> 16 & 0xFFL);
        this.data[this.index++] = (byte)(l >> 24 & 0xFFL);
    }

    public void writeByte(byte by) {
        this.data[this.index++] = by;
    }

    public void writeShort(short s) {
        this.data[this.index++] = (byte)(s & 0xFF);
        this.data[this.index++] = (byte)(s >> 8);
    }

    public void writeInt(int n) {
        this.data[this.index++] = (byte)(n & 0xFF);
        this.data[this.index++] = (byte)(n >> 8 & 0xFF);
        this.data[this.index++] = (byte)(n >> 16 & 0xFF);
        this.data[this.index++] = (byte)(n >> 24 & 0xFF);
    }

    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.data, this.index, n2);
        this.index += n2;
    }

    public void writeString(String string, int n, String string2) {
        try {
            byte[] byArray = string.getBytes(string2);
            if (byArray.length != n) {
                throw new JMACException("Wrong Value");
            }
            System.arraycopy(byArray, 0, this.data, this.index, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMACException("Unsupported Encoding", unsupportedEncodingException);
        }
        this.index += n;
    }

    public void writeZString(String string, String string2) {
        try {
            byte[] byArray = string.getBytes(string2);
            System.arraycopy(byArray, 0, this.data, this.index, byArray.length);
            this.index += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JMACException("Unsupported Encoding", unsupportedEncodingException);
        }
        this.data[this.index++] = 0;
    }
}

