/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.ogg.jorbis;

import de.quippy.ogg.jorbis.Comment;
import de.quippy.ogg.jorbis.Info;
import de.quippy.ogg.jorbis.VorbisFile;

class ChainingExample {
    ChainingExample() {
    }

    public static void main(String[] stringArray) {
        VorbisFile vorbisFile = null;
        try {
            vorbisFile = stringArray.length > 0 ? new VorbisFile(stringArray[0]) : new VorbisFile(System.in, null, -1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
        if (vorbisFile.seekable()) {
            System.out.println("Input bitstream contained " + vorbisFile.streams() + " logical bitstream section(s).");
            System.out.println("Total bitstream playing time: " + vorbisFile.time_total(-1) + " seconds\n");
        } else {
            System.out.println("Standard input was not seekable.");
            System.out.println("First logical bitstream information:\n");
        }
        int n = 0;
        while (n < vorbisFile.streams()) {
            Info info = vorbisFile.getInfo(n);
            System.out.println("\tlogical bitstream section " + (n + 1) + " information:");
            System.out.println("\t\t" + info.rate + "Hz " + info.channels + " channels bitrate " + vorbisFile.bitrate(n) / 1000 + "kbps serial number=" + vorbisFile.serialnumber(n));
            System.out.print("\t\tcompressed length: " + vorbisFile.raw_total(n) + " bytes ");
            System.out.println(" play time: " + vorbisFile.time_total(n) + "s");
            Comment comment = vorbisFile.getComment(n);
            System.out.println(comment);
            ++n;
        }
    }
}

