import {AbstractButton, AbstractButtonView} from "./abstract_button"
import {classes} from "core/dom"
import * as p from "core/properties"

import * as inputs from "styles/buttons.css"

export class ToggleView extends AbstractButtonView {
  model: Toggle

  connect_signals(): void {
    super.connect_signals()
    this.connect(this.model.properties.active.change, () => this._update_active())
  }

  render(): void {
    super.render()
    this._update_active()
  }

  click(): void {
    this.model.active = !this.model.active
    super.click()
  }

  protected _update_active(): void {
    classes(this.button_el).toggle(inputs.active, this.model.active)
  }
}

export namespace Toggle {
  export type Attrs = p.AttrsOf<Props>

  export type Props = AbstractButton.Props & {
    active: p.Property<boolean>
  }
}

export interface Toggle extends Toggle.Attrs {}

export class Toggle extends AbstractButton {
  properties: Toggle.Props
  __view_type__: ToggleView

  constructor(attrs?: Partial<Toggle.Attrs>) {
    super(attrs)
  }

  static init_Toggle(): void {
    this.prototype.default_view = ToggleView

    this.define<Toggle.Props>(({Boolean}) => ({
      active: [ Boolean, false ],
    }))

    this.override<Toggle.Props>({
      label: "Toggle",
    })
  }
}
