const _ = module.exports = {};
const path = require('path');
const cmlUtils = require('chameleon-tool-utils');
const fse = require('fs-extra');

_.handleApptabbar = function(newJsonObj, filePath, type) {
  filePath = path.dirname(filePath); // 得到 app.cml 文件所在目录
  let tabbarIconPaths = _.getTabbarIconPaths(newJsonObj.tabBar, type);
  if (tabbarIconPaths.length) {
    tabbarIconPaths.forEach((item) => {
      let rootDir = path.resolve(cml.projectRoot, `dist/${type}`);

      let destIconPath = path.resolve(rootDir, item.finalPath); // 获取到要将icon拷贝的路径
      let sourceIconPath = path.resolve(filePath, item.originPath) // 获取到原来的icon的路径
      if (cmlUtils.isFile(sourceIconPath)) {
        fse.copySync(sourceIconPath, destIconPath)
      } else {
        cmlUtils.log.warn(`${sourceIconPath} is not exsit`)
      }

    });
  }
}
_.getRelativeIconPath = function(p) {
  let fileName = path.parse(p).base;
  return path.join('./icon', fileName)
}
_.getTabbarIconPaths = function(tabbar, type) {
  let iconPaths = [];
  let miniAppType = ['wx', 'baidu', 'qq', 'tt']

  if (tabbar && miniAppType.includes(type)) {
    (tabbar.list || []).forEach((item) => {
      if (item.iconPath) {
        let iconInfo = {};
        iconInfo.originPath = item.iconPath;
        item.iconPath = _.getRelativeIconPath(item.iconPath);
        iconInfo.finalPath = item.iconPath;

        iconPaths.push(iconInfo);
        // 生成的app.json中的路径要适配windows
        item.iconPath = cmlUtils.handleWinPath(item.iconPath);
      }
      if (item.selectedIconPath) {
        let iconInfo = {};
        iconInfo.originPath = item.selectedIconPath;
        item.selectedIconPath = _.getRelativeIconPath(item.selectedIconPath);
        iconInfo.finalPath = item.selectedIconPath;

        iconPaths.push(iconInfo);
        // 生成的app.json中的路径要适配windows
        item.selectedIconPath = cmlUtils.handleWinPath(item.selectedIconPath);
      }
    })
  }
  if (tabbar && type === 'alipay') {
    (tabbar.items || []).forEach((item) => {
      if (item.icon) {
        let iconInfo = {};
        iconInfo.originPath = item.icon;
        item.icon = _.getRelativeIconPath(item.icon);
        iconInfo.finalPath = item.icon;

        iconPaths.push(iconInfo);

        // 生成的app.json中的路径要适配windows
        item.icon = cmlUtils.handleWinPath(item.icon);
      }
      if (item.activeIcon) {
        let iconInfo = {};
        iconInfo.originPath = item.activeIcon;
        item.activeIcon = _.getRelativeIconPath(item.activeIcon);
        iconInfo.finalPath = item.activeIcon;

        iconPaths.push(iconInfo);

        // 生成的app.json中的路径要适配windows
        item.activeIcon = cmlUtils.handleWinPath(item.activeIcon);
      }
    })
  }
  return iconPaths;
}
_.handleWorkers = function(newJsonObj, type, loaderContext) {
  const workers = newJsonObj.workers;
  if (workers) {
    const destDir = path.resolve(cml.projectRoot, `dist/${type}`, workers);
    const sourceDir = path.resolve(cml.projectRoot, 'src/', workers);

    if (cmlUtils.isDir(sourceDir)) {
      fse.copySync(sourceDir, destDir);
      loaderContext.addContextDependency(sourceDir)

    }
  }
}
