var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
//////// GLOBALS
var dom = {
    minimize: document.querySelector('.chrome-buttons .minimize'),
    maximize: document.querySelector('.chrome-buttons .maximize'),
    maximizeIcon: document.querySelector('.chrome-buttons .maximize img'),
    close: document.querySelector('.chrome-buttons .close'),
    middleContent: document.querySelector('.middle-content'),
    clips: document.getElementById('clips-wrapper'),
    clipPreview: document.getElementById('clip-preview'),
    clipPreviewVideo: document.querySelector('#clip-preview video'),
    clipPreviewSource: document.querySelector('#clip-preview video source'),
    obsStatusText: document.getElementById('obs-status-text'),
    obsStatusInfo: document.getElementById('obs-status-info'),
    obsCpuPercent: document.getElementById('obs-cpu-percent'),
    obsFps: document.getElementById('obs-fps'),
    obsPollingInterval: document.getElementById('obs-polling-interval'),
    triggersList: document.getElementById('triggers-list'),
    clipItBtn: document.getElementById('clip-it-btn'),
    overlay: document.getElementById('overlay'),
    modalContent: document.querySelector('#modal .modal-content'),
    modalTitle: document.querySelector('#modal .modal-title'),
    quitBtn: document.getElementById('quit-btn'),
    fab: document.querySelector('.fab'),
    feedback: document.getElementById('feedback'),
    playNew: document.getElementById('play-new'),
    soundEffectDemo: document.getElementById('sound-effect-demo'),
    gameSelect: document.getElementById('game-select'),
    gameWaitingOption: document.getElementById('game-waiting-option'),
    gameAutoDetect: document.getElementById('game-auto-detect'),
};
var sections = [
    {
        date: new Date(),
        elem: document.getElementById('this-session-clips'),
    }
];
var clips = [];
var configs = [];
var startupTime = new Date();
var playlist = [];
var soundEffects = {
    newClip: new Audio('sound/camera.wav'),
    deleteClip: new Audio('sound/recycle.wav'),
};
var activeClip = null;
var autoSelectGame = true;
//////// METHODS
function unsetActiveClip() {
    if (!activeClip)
        return;
    activeClip.elem.classList.remove('active');
    activeClip = null;
    dom.clipPreviewVideo.pause();
    dom.clipPreviewSource.src = '';
}
function setActiveClip(clip) {
    unsetActiveClip();
    clip.new = false;
    clip.elem.classList.add('active');
    clip.elem.classList.remove('new');
    checkNewClips();
    activeClip = clip;
    var wrapper = dom.clipPreview;
    var video = dom.clipPreviewVideo;
    var source = dom.clipPreviewSource;
    wrapper.classList.add('visible');
    source.src = clip.elem.querySelector('source').src;
    video.load();
    video.play();
}
function checkNewClips() {
    var newClips = clips.filter(function (clip) { return clip.new; });
    if (newClips.length === 0)
        dom.playNew.classList.remove('visible');
}
function checkEmptyState() {
    if (clips.length === 0)
        dom.middleContent.classList.add('empty');
    else
        dom.middleContent.classList.remove('empty');
}
function handleClips() {
    function clipOnClick(clip) {
        console.log("Clicked clip: " + clip.path);
        if (activeClip === clip) {
            unsetActiveClip();
            dom.clipPreview.classList.remove('visible');
        }
        else
            setActiveClip(clip);
    }
    function deleteClip(clip, event) {
        console.log("Delete clip: " + clip.path);
        if (activeClip === clip) {
            unsetActiveClip();
            dom.clipPreview.classList.remove('visible');
        }
        window.electron.ipcRenderer.invoke('deleteClip', clip.path);
        event.stopPropagation();
        event.preventDefault();
        return false;
    }
    var getClipSection = function (date) {
        for (var i = 0; i <= sections.length; i++) {
            var section = sections[i];
            if (section.date.getDate() === date.getDate()
                && section.date.getMonth() === date.getMonth()
                && section.date.getFullYear() === date.getFullYear()) {
                return section;
            }
            if (date < section.date || i === sections.length) {
                // Container
                var elem = document.createElement('div');
                elem.classList.add('clip-section');
                dom.clips.insertBefore(elem, section.elem.nextSibling);
                //dom.clips.appendChild(elem)
                // Heading
                var h3 = document.createElement('h3');
                h3.innerText = "" + date.toDateString();
                elem.appendChild(h3);
                // Publish
                var newSection = { date: date, elem: elem };
                sections.splice(i, 0, newSection);
                return newSection;
            }
        }
        throw new Error("Could not find or create a section for clip with date " + date);
    };
    var onClipAdd = function (path, stat) {
        console.log("Clip added: " + path);
        // Ignore non-video files
        var split = path.split('.');
        var videoExtensions = ['flv', 'mp4', 'mov', 'mkv', 'ts', 'm3u8'];
        if (split.length < 2 || !videoExtensions.includes(split[1].toLowerCase())) {
            console.warn("Ignoring file with extension " + split[1]);
            return;
        }
        // Construct ClipData
        var date = new Date(stat.birthtimeMs);
        var elem = document.createElement('div');
        var isNew = date > startupTime;
        var clipData = { path: path, date: date, new: isNew, elem: elem };
        var section = getClipSection(date);
        // Prepare DOM element
        elem.onclick = function () { return clipOnClick(clipData); };
        elem.classList.add('clip');
        if (isNew) {
            elem.classList.add('new');
            dom.playNew.classList.add('visible');
            soundEffects.newClip.currentTime = 0;
            soundEffects.newClip.volume = 0.5;
            soundEffects.newClip.play();
        }
        elem.tabIndex = 0;
        var innerHTML = "<video><source src=\"" + path + "\"></source></video>";
        innerHTML += "<img src=\"trash.svg\" alt=\"Delete\" class=\"trash\" title=\"Delete clip\" tabindex=\"0\">";
        elem.innerHTML = innerHTML;
        // Handle trash button click
        var img = elem.querySelector('.trash');
        img.onclick = function (event) {
            var sure = confirm("Are you sure you want to delete " + path + "?");
            if (!sure)
                return;
            deleteClip(clipData, event);
            soundEffects.deleteClip.currentTime = 0;
            soundEffects.deleteClip.volume = 0.5;
            soundEffects.deleteClip.play();
            event.preventDefault();
            event.stopPropagation();
            return false;
        };
        // Handle video loading problems
        var video = elem.querySelector('video');
        var source = video.querySelector('source');
        video.retries = 0;
        var retryDelay = 500;
        var MAX_RETRIES = 5;
        var checkLoaded = function () {
            setTimeout(function () {
                if (video.networkState !== HTMLMediaElement.NETWORK_NO_SOURCE)
                    return;
                console.warn("Could not load video; Trying again in " + retryDelay + "ms");
                if (video.retries++ >= MAX_RETRIES) {
                    console.error("Cannot load " + path + "; tried " + MAX_RETRIES + " times");
                    return;
                }
                var sourceBase = source.src.split('?')[0];
                source.src = sourceBase + "?retry=" + video.retries;
                video.load();
                checkLoaded();
            }, retryDelay);
        };
        checkLoaded();
        // Publish
        section.elem.appendChild(elem);
        clips.push(clipData);
        checkEmptyState();
    };
    var onClipRemove = function (path, stat) {
        console.log("Clip removed: " + path);
        var clipData = clips.find(function (clip) { return clip.path === path; });
        if (!clipData)
            return;
        clipData.elem.parentNode.removeChild(clipData.elem);
        clips.splice(clips.indexOf(clipData), 1);
        checkNewClips();
        checkEmptyState();
    };
    window.electron.ipcRenderer.on('clipAdd', onClipAdd);
    window.electron.ipcRenderer.on('clipRemove', onClipRemove);
}
function handleObsStats() {
    var onObsStats = function (stats) {
        var _a;
        if (!((_a = dom.obsStatusText.textContent) === null || _a === void 0 ? void 0 : _a.includes('Connected'))) {
            dom.obsStatusText.innerHTML = '✔️ Connected to OBS';
            dom.obsStatusInfo.classList.add('visible');
        }
        dom.obsCpuPercent.innerHTML = Math.round(stats['cpu-usage']) + "%";
        dom.obsFps.innerHTML = "" + Math.round(stats['fps']);
        dom.obsPollingInterval.innerHTML = Math.round(stats.pollingInterval) + "ms";
    };
    window.electron.ipcRenderer.on('obsStats', onObsStats);
}
function handleTriggers(config) {
    if (!config)
        return;
    var onTriggerClick = function (trigger) {
        console.log("Clicked " + trigger.title);
        trigger.enabled = !trigger.enabled;
        window.electron.ipcRenderer.invoke('setTriggerEnabled', trigger.id, trigger.enabled);
    };
    var toggleSwitch = function (elem) {
        if (elem.classList.contains('off')) {
            elem.classList.remove('off');
            elem.classList.add('on');
        }
        else {
            elem.classList.remove('on');
            elem.classList.add('off');
        }
    };
    dom.triggersList.innerHTML = '';
    var section = dom.triggersList.parentNode;
    section.style.display = config.triggers.length === 0 ? 'none' : 'block';
    config.triggers.forEach(function (trigger) {
        var elem = document.createElement('div');
        elem.classList.add('trigger');
        if (!trigger.enabled)
            elem.classList.add('off');
        elem.tabIndex = 0;
        var innerHTML = trigger.title;
        innerHTML += "<div class=\"toggle " + (trigger.enabled ? 'on' : 'off') + "\"></div>";
        elem.innerHTML = innerHTML;
        elem.onclick = function () {
            toggleSwitch(elem.querySelector('.toggle'));
            toggleSwitch(elem);
            onTriggerClick(trigger);
        };
        dom.triggersList.appendChild(elem);
    });
}
function getSelectedConfig() {
    if (dom.gameSelect.value === dom.gameWaitingOption.value)
        return { id: dom.gameWaitingOption.value, title: dom.gameWaitingOption.innerText, triggers: [] };
    return configs.find(function (config) { return config.id === dom.gameSelect.value; });
}
function onGameSelect() {
    var selectedConfig = getSelectedConfig();
    if (selectedConfig) {
        handleTriggers(selectedConfig);
        window.electron.ipcRenderer.invoke('setSelectedConfig', selectedConfig);
    }
}
function handleTriggerConfigs() {
    return __awaiter(this, void 0, void 0, function () {
        var configsReceived;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, window.electron.ipcRenderer.invoke('getAllConfigs')];
                case 1:
                    configsReceived = _a.sent();
                    configs.push.apply(configs, configsReceived);
                    configs.forEach(function (config) {
                        var option = document.createElement('option');
                        option.innerText = config.title;
                        option.value = config.id;
                        dom.gameSelect.appendChild(option);
                    });
                    onGameSelect();
                    dom.gameSelect.onchange = function () {
                        if (autoSelectGame)
                            dom.gameAutoDetect.click();
                        onGameSelect();
                    };
                    return [2 /*return*/];
            }
        });
    });
}
function handleManualClip() {
    dom.clipItBtn.onclick = function () { return window.electron.ipcRenderer.invoke('clip'); };
}
function handleErrors() {
    dom.quitBtn.onclick = function () { return window.electron.ipcRenderer.invoke('quit'); };
    window.electron.ipcRenderer.on('obsError', function (error) {
        console.error(error);
        dom.overlay.classList.add('visible');
        dom.modalTitle.innerHTML = "\uD83D\uDC80 " + error.title;
        dom.modalContent.innerHTML = error.msg; //.replaceAll('\n', '<br>')
    });
}
function handleFeedback() {
    dom.fab.onclick = function () { return dom.feedback.classList.add('visible'); };
    dom.feedback.onmouseleave = function () { return dom.feedback.classList.remove('visible'); };
}
function handlePlayNew() {
    var onEnded = function () {
        if (playlist.length === 0)
            return;
        setActiveClip(playlist.shift());
    };
    var onPlayNew = function () {
        console.log('Playing all new clips');
        playlist.push.apply(playlist, clips.filter(function (clip) { return clip.new; }));
        onEnded();
    };
    dom.playNew.onclick = onPlayNew;
    dom.clipPreviewVideo.onended = onEnded;
}
function handleSounds() {
    dom.soundEffectDemo.onclick = function () {
        soundEffects.newClip.currentTime = 0;
        soundEffects.newClip.volume = 0.5;
        soundEffects.newClip.play();
    };
}
function handleChrome() {
    dom.minimize.onclick = function () { return window.electron.ipcRenderer.invoke('minimize'); };
    dom.maximize.onclick = function () {
        if (dom.maximizeIcon.src.includes('maximize'))
            dom.maximizeIcon.src = 'codicon-chrome-restore.svg';
        else
            dom.maximizeIcon.src = 'codicon-chrome-maximize.svg';
        window.electron.ipcRenderer.invoke('maximize');
    };
    dom.close.onclick = function () { return window.electron.ipcRenderer.invoke('close'); };
}
function handleGameAutoDetect() {
    var onGameRunning = function (game) {
        if (!autoSelectGame)
            return;
        // No game running
        if (game === '') {
            if (dom.gameSelect.value !== dom.gameWaitingOption.value) {
                console.log("Switched to waiting for game");
                dom.gameSelect.value = dom.gameWaitingOption.value;
                onGameSelect();
            }
            return;
        }
        // Game running
        var config = configs.find(function (config) { return config.exe && config.exe.toLowerCase() === game.toLowerCase(); });
        if (!config)
            return console.error("Could not find config for " + game);
        if (dom.gameSelect.value === config.id)
            return;
        console.log("Switched to game " + config.id);
        dom.gameSelect.value = config.id;
        onGameSelect();
    };
    var onCheckboxClick = function () {
        autoSelectGame = dom.gameAutoDetect.checked;
        var label = dom.gameAutoDetect.parentNode;
        label.classList.toggle('off');
        dom.gameSelect.title = autoSelectGame ? 'Disable auto selection to manually change the game' : '';
        dom.gameWaitingOption.innerText = autoSelectGame ? 'Waiting for game...' : 'Select game...';
    };
    dom.gameAutoDetect.onclick = onCheckboxClick;
    window.electron.ipcRenderer.on('gameRunning', onGameRunning);
}
//////// MAIN
function main() {
    console.log('Clipit started');
    window.electron.ipcRenderer.invoke('initChokidar');
    handleClips();
    handleObsStats();
    handleTriggerConfigs();
    handleManualClip();
    handleErrors();
    handleFeedback();
    handlePlayNew();
    handleSounds();
    handleChrome();
    handleGameAutoDetect();
}
main();
export {};
