"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var package_json_1 = __importDefault(require("../package.json"));
var HypetriggerManager_1 = __importDefault(require("../src/lib/HypetriggerManager"));
var OBSManager_1 = __importDefault(require("../src/lib/OBSManager"));
var badge_1 = __importDefault(require("../src/triggers/badge"));
var kill_notif_1 = __importDefault(require("../src/triggers/kill-notif"));
var kill_total_1 = __importDefault(require("../src/triggers/kill-total"));
var warzone_victory_1 = __importDefault(require("../src/triggers/warzone-victory"));
var yellow_text_1 = __importDefault(require("../src/triggers/yellow-text"));
// Globals
var manager = new HypetriggerManager_1["default"]();
var obs = new OBSManager_1["default"]();
var triggers = [
    new kill_total_1["default"]({ title: 'Kill Total', manager: manager }),
    new yellow_text_1["default"]({ title: 'Yellow Text', manager: manager }),
    new badge_1["default"]({ title: 'Badges', manager: manager }),
    new kill_notif_1["default"]({ title: 'Kill Notification', manager: manager }),
    new warzone_victory_1["default"]({ title: 'Warzone Victory', manager: manager }),
];
function main() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log("Clip It v" + package_json_1["default"].version);
                    console.log("===============================");
                    // createWindow()
                    return [4 /*yield*/, initOBS()];
                case 1:
                    // createWindow()
                    _a.sent();
                    return [4 /*yield*/, startTesseract()];
                case 2:
                    _a.sent();
                    console.log("Game is hardcoded to COD: Warzone");
                    console.log("Make sure OBS is recording the correct display/game capture");
                    console.log("Clips will appear in your OBS output directory: " + obs.settings.ClipDirectory);
                    console.log("===============================");
                    console.log("Ready to clip automatically...");
                    return [2 /*return*/];
            }
        });
    });
}
function runTrigger(trigger) {
    return __awaiter(this, void 0, void 0, function () {
        var err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 3, 4, 5]);
                    if (!obs.screenshot) return [3 /*break*/, 2];
                    return [4 /*yield*/, trigger.run(obs.screenshot)];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2: return [3 /*break*/, 5];
                case 3:
                    err_1 = _a.sent();
                    console.error(err_1);
                    return [3 /*break*/, 5];
                case 4:
                    if (trigger.runForever)
                        runTrigger(trigger);
                    return [7 /*endfinally*/];
                case 5: return [2 /*return*/];
            }
        });
    });
}
function initOBS() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, obs.init()];
                case 1:
                    _a.sent();
                    obs.getScreenshot();
                    return [2 /*return*/];
            }
        });
    });
}
function startTesseract() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    manager.onEvent(function (event) {
                        if (!['kill', 'warzone-victory', 'badge'].includes(event.type))
                            return;
                        var recentClip = manager.eventLog.find(function (event) {
                            return event.type === 'clip'
                                && new Date().getTime() - event.timestamp.getTime() < obs.settings.ClipDuration * 1000;
                        });
                        if (recentClip) {
                            //console.log('Skipping due to recent clip')
                            return;
                        }
                        manager.logEvent({
                            type: 'clip',
                            msg: 'CLIP IT!',
                            timestamp: new Date()
                        });
                        setTimeout(obsClip, obs.settings.ClipDelay ? obs.settings.ClipDelay * 1000 : 0);
                    });
                    return [4 /*yield*/, manager.initTesseract()];
                case 1:
                    _a.sent();
                    triggers.forEach(runTrigger);
                    return [2 /*return*/];
            }
        });
    });
}
function obsClip() {
    if (!obs) {
        console.error('No obs instance');
        return;
    }
    obs.ws.send('SaveReplayBuffer')
        .then(function () { return console.log("Saved clip to " + obs.settings.ClipDirectory); })["catch"](console.error);
}
main();
//# sourceMappingURL=lite.js.map