"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var chokidar_1 = require("chokidar");
var electron_1 = require("electron");
var fs_1 = require("fs");
var original_fs_1 = require("original-fs");
var path_1 = require("path");
var package_json_1 = __importDefault(require("../package.json"));
var GameAutoDetect_1 = __importDefault(require("../src/lib/GameAutoDetect"));
var HypetriggerManager_1 = __importDefault(require("../src/lib/HypetriggerManager"));
var OBSManager_1 = __importDefault(require("../src/lib/OBSManager"));
var triggerFromJson_1 = __importDefault(require("../src/lib/triggerFromJson"));
// Globals
var manager = new HypetriggerManager_1["default"]();
var obs = new OBSManager_1["default"]();
var gameAutoDetect = new GameAutoDetect_1["default"]();
var mainWindow;
var triggers = [];
var selectedConfig = null;
var obsError = null;
var configs = [];
// Hard-coded startup
electron_1.app.on('ready', function () { return __awaiter(void 0, void 0, void 0, function () {
    var e_1;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 3, , 4]);
                console.log("Clip It v" + package_json_1["default"].version);
                console.log("===============================");
                initDebug();
                createWindow();
                return [4 /*yield*/, initOBS()];
            case 1:
                _a.sent();
                return [4 /*yield*/, initTesseract()];
            case 2:
                _a.sent();
                console.log("Make sure OBS is recording the correct display/game capture");
                console.log("Clips will appear in your OBS output directory: " + obs.settings.ClipDirectory);
                console.log("===============================");
                console.log("Ready to clip automatically...");
                return [3 /*break*/, 4];
            case 3:
                e_1 = _a.sent();
                console.error(e_1);
                return [3 /*break*/, 4];
            case 4: return [2 /*return*/];
        }
    });
}); });
function createWindow() {
    mainWindow = new electron_1.BrowserWindow({
        width: 1920,
        height: 1080,
        frame: false,
        show: false,
        webPreferences: {
            nodeIntegration: false,
            contextIsolation: true,
            enableRemoteModule: false,
            preload: path_1.join(__dirname, 'preload.js') // use a preload script
        },
        icon: __dirname + "/../public/clipit-logo-vertical-light.png"
    });
    var startURL = "file://" + path_1.join(__dirname, '../public/index.html');
    mainWindow.setMenuBarVisibility(false);
    mainWindow.loadURL(startURL);
    mainWindow.once('ready-to-show', function () { return mainWindow.show(); });
    mainWindow.webContents.setWindowOpenHandler(function (_a) {
        var url = _a.url;
        console.log("Opening new window in a browser: " + url);
        electron_1.shell.openExternal(url);
        return { action: 'deny' };
    });
    // mainWindow.on('closed', () => { mainWindow = null })
}
function initOBS() {
    return __awaiter(this, void 0, void 0, function () {
        var e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    obs.onError = function (err) {
                        //err.msg.split('\n').forEach(console.error)
                        obsError = err;
                        mainWindow.webContents.send('obsError', err);
                    };
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, , 5]);
                    return [4 /*yield*/, obs.init()];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, obs.getScreenshot(function (stats) {
                            stats.pollingInterval = obs.screenshotPollingInterval;
                            mainWindow.webContents.send('obsStats', stats);
                        })];
                case 3:
                    _a.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_2 = _a.sent();
                    throw e_2; // rethrow
                case 5: return [2 /*return*/];
            }
        });
    });
}
function initDebug() {
    var DEBUG_DIR = 'debug';
    if (original_fs_1.existsSync(DEBUG_DIR))
        return;
    fs_1.mkdirSync(DEBUG_DIR);
    console.log("Created directory for debug output at " + DEBUG_DIR);
}
function initChokidar() {
    if (obsError) {
        obs.onError(obsError); // Re-send the error message if it was too soon the first time
        return;
    }
    var path = obs.settings.ClipDirectory;
    console.log("Watching clip directory for changes: " + path);
    var watcher = chokidar_1.watch(path);
    watcher
        .on('add', function (path, stats) { console.log("Clip added: " + path); mainWindow.webContents.send('clipAdd', path, stats); })
        // .on('change', (path: any, stats: Stats) => { console.log(`Clip changed: ${path}`); mainWindow.webContents.send('clipChange', path, stats) })
        .on('unlink', function (path, stats) { console.log("Clip removed: " + path); mainWindow.webContents.send('clipRemove', path, stats); });
}
function initTesseract(event) {
    return __awaiter(this, void 0, void 0, function () {
        var prophylaxis;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    manager.eventListeners = [];
                    manager.onEvent(function (event) {
                        if (!selectedConfig)
                            return;
                        var presetEvent = selectedConfig.triggers.find(function (trigger) { return trigger.id === event.type; });
                        if (!presetEvent || !presetEvent.enabled)
                            return;
                        // Don't let clips overlay (give the replay buffer time to fill completely)
                        var recentClip = manager.eventLog.find(function (event) {
                            return event.type === 'clip'
                                && new Date().getTime() - event.timestamp.getTime() < obs.settings.ClipDuration * 1000;
                        });
                        if (recentClip)
                            return;
                        manager.logEvent({
                            type: 'clip',
                            msg: 'CLIP IT!',
                            timestamp: new Date()
                        });
                        setTimeout(obsClip, obs.settings.ClipDelay ? obs.settings.ClipDelay * 1000 : 0);
                    });
                    return [4 /*yield*/, manager.initTesseract()];
                case 1:
                    _a.sent();
                    prophylaxis = function () { return __awaiter(_this, void 0, void 0, function () {
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    console.log('Preemptively restarting Tesserract to flush RAM');
                                    return [4 /*yield*/, manager.restartTesseract()];
                                case 1:
                                    _a.sent();
                                    return [2 /*return*/];
                            }
                        });
                    }); };
                    setInterval(prophylaxis, 1000 * 60 * 15); // every 15 minutes
                    triggers.forEach(runTrigger);
                    return [2 /*return*/];
            }
        });
    });
}
function runTrigger(trigger) {
    return __awaiter(this, void 0, void 0, function () {
        var err_1, delay;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!trigger.enabled)
                        return [2 /*return*/];
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, 5, 6]);
                    if (!(obs.screenshot && manager.tesseractInitialized)) return [3 /*break*/, 3];
                    trigger.lastScreenshotNumber = obs.screenshotNumber;
                    return [4 /*yield*/, trigger.run(obs.screenshot)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [3 /*break*/, 6];
                case 4:
                    err_1 = _a.sent();
                    console.error(err_1);
                    return [3 /*break*/, 6];
                case 5:
                    if (trigger.runForever) {
                        delay = 100;
                        if (obs.screenshotNumber === trigger.lastScreenshotNumber)
                            delay = obs.nextScreenshotTime - Date.now();
                        if (delay < 100)
                            delay = 100; // minimum delay for a bit of breathing room
                        //console.log(`${trigger.title} delay=${delay}ms`)
                        setTimeout(function () { return runTrigger(trigger); }, delay);
                    }
                    return [7 /*endfinally*/];
                case 6: return [2 /*return*/];
            }
        });
    });
}
function obsClip() {
    if (!obs) {
        console.error('No obs instance');
        return;
    }
    obs.ws.send('SaveReplayBuffer')
        .then(function () { return console.log("Saved clip to " + obs.settings.ClipDirectory); })["catch"](console.error);
}
function deleteClip(event, path) {
    try {
        fs_1.unlinkSync(path);
        console.log("Deleted " + path);
    }
    catch (err) {
        console.log("Error deleting " + path);
        console.error(err);
    }
}
/**
 * Note a minor distinction between "raw" triggers (the actual triggers array in main.ts)
 * versus the "preset" triggers which are shown to the user in the UI.
 * These may overlap but are not guaranteed to be the same, despite the similar naming!
 */
function setTriggerEnabled(event, triggerEvent, enabled) {
    if (!selectedConfig)
        return;
    var triggerConfig = selectedConfig.triggers.find(function (trigger) { return trigger.id === triggerEvent; });
    var trigger = triggers.find(function (trigger) { return trigger.id === triggerEvent; });
    if (!triggerConfig || !trigger) {
        console.warn("Could not find specified trigger event " + triggerEvent);
        return;
    }
    trigger.enabled = enabled;
    triggerConfig.enabled = enabled;
    if (trigger.enabled)
        runTrigger(trigger);
    console.log("Set trigger " + triggerEvent + " to " + enabled);
}
function restartTesseract(event) {
    manager.restartTesseract();
}
function quit(event) {
    console.log('Render thread requested quit');
    electron_1.app.quit();
}
function close(event) {
    mainWindow.close();
}
function minimize(event) {
    mainWindow.minimize();
}
function maximize(event) {
    if (!mainWindow.isMaximized())
        mainWindow.maximize();
    else
        mainWindow.unmaximize();
}
function getAllConfigs(event) {
    var path = path_1.resolve(__dirname, '../public/clipit-configs/configs');
    configs = [];
    fs_1.readdirSync(path).forEach(function (file) {
        try {
            if (path_1.extname(file) !== '.json')
                return;
            var config = JSON.parse(fs_1.readFileSync(path + "/" + file, 'utf8'));
            configs.push(config);
            console.log("Found config " + file);
        }
        catch (e) {
            console.error("Failed to get config file " + path + "/" + file);
            console.error(e);
        }
    });
    // Start game auto detection
    gameAutoDetect.games = configs.map(function (config) { return config.exe; }).filter(function (exe) { return !!exe; });
    gameAutoDetect.callback = function (game) { return mainWindow.webContents.send('gameRunning', game); };
    gameAutoDetect.period = 1000;
    gameAutoDetect.start();
    return configs;
}
function setSelectedConfig(event, config) {
    if (selectedConfig && selectedConfig.id === config.id)
        return;
    selectedConfig = config;
    triggers.forEach(function (trigger) { return trigger.enabled = false; });
    triggers = selectedConfig.triggers.map(function (triggerJson) { return triggerFromJson_1["default"](triggerJson, manager); });
    console.log("Selected config " + selectedConfig.title);
    if (manager.tesseractInitialized)
        triggers.forEach(runTrigger);
}
// IPC comms
electron_1.ipcMain.handle('deleteClip', deleteClip);
electron_1.ipcMain.handle('setTriggerEnabled', setTriggerEnabled);
electron_1.ipcMain.handle('clip', obsClip);
electron_1.ipcMain.handle('initChokidar', initChokidar);
electron_1.ipcMain.handle('restartTesseract', restartTesseract);
electron_1.ipcMain.handle('quit', quit);
electron_1.ipcMain.handle('close', close);
electron_1.ipcMain.handle('minimize', minimize);
electron_1.ipcMain.handle('maximize', maximize);
electron_1.ipcMain.handle('getAllConfigs', getAllConfigs);
electron_1.ipcMain.handle('setSelectedConfig', setSelectedConfig);
//# sourceMappingURL=main.js.map