"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var CropFunction = /** @class */ (function () {
    function CropFunction(config) {
        if (config === void 0) { config = {}; }
        this.yAnchor = 'top';
        this.xAnchor = 'left';
        this.x = 0;
        this.y = 0;
        this.xUnit = 'px';
        this.yUnit = 'px';
        this.width = 100;
        this.height = 100;
        this.widthUnit = '%';
        this.heightUnit = '%';
        this.yAnchor = config.yAnchor || this.yAnchor;
        this.xAnchor = config.xAnchor || this.xAnchor;
        this.x = config.x || this.x;
        this.y = config.y || this.y;
        this.xUnit = config.xUnit || this.xUnit;
        this.yUnit = config.yUnit || this.yUnit;
        this.width = config.width || this.width;
        this.height = config.height || this.height;
        this.widthUnit = config.widthUnit || this.widthUnit;
        this.heightUnit = config.heightUnit || this.heightUnit;
    }
    /**
     * Renders a cropped section of @param video onto a given @param canvas,
     * according to the various parameters set as member fields of the CropFunction object
     */
    CropFunction.prototype.cropImage = function (sharp) {
        return __awaiter(this, void 0, void 0, function () {
            var region, metadata, extract;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        region = {
                            top: this.y,
                            left: this.x,
                            width: this.width,
                            height: this.height
                        };
                        return [4 /*yield*/, sharp.metadata()];
                    case 1:
                        metadata = _a.sent();
                        if (this.yUnit === '%')
                            region.top *= metadata.height / 100;
                        if (this.yAnchor === 'bottom')
                            region.top = metadata.height - region.top;
                        if (this.heightUnit === '%')
                            region.height *= metadata.height / 100;
                        if (this.xUnit === '%')
                            region.left *= metadata.width / 100;
                        if (this.xAnchor === 'right')
                            region.left = metadata.width - region.left;
                        if (this.widthUnit === '%')
                            region.width *= metadata.width / 100;
                        region.top = Math.round(region.top);
                        region.left = Math.round(region.left);
                        region.width = Math.round(region.width);
                        region.height = Math.round(region.height);
                        return [4 /*yield*/, sharp.extract(region)];
                    case 2:
                        extract = _a.sent();
                        return [2 /*return*/, Promise.resolve(extract)];
                }
            });
        });
    };
    return CropFunction;
}());
exports["default"] = CropFunction;
//# sourceMappingURL=CropFunction.js.map