"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.NUM_TESSERACT_WORKERS = void 0;
var tesseract_js_1 = require("tesseract.js");
exports.NUM_TESSERACT_WORKERS = 3;
var HypetriggerManager = /** @class */ (function () {
    function HypetriggerManager() {
        /** Array of game events (kills, streaks, other info) */
        this.eventLog = [];
        /** Collection of all parsed text for comparison & combination */
        this.parseHistory = [];
        /** Flag to ensure that tesseract only gets initialized once */
        this.tesseractInitialized = false;
        /** Observer pattern for event log */
        this.eventListeners = [];
    }
    HypetriggerManager.prototype.initTesseract = function () {
        return __awaiter(this, void 0, void 0, function () {
            var i, worker;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.tesseractInitialized)
                            return [2 /*return*/];
                        this.scheduler = tesseract_js_1.createScheduler();
                        this.logEvent({
                            type: 'debug',
                            timestamp: new Date(),
                            msg: 'Initializing Tesseract...'
                        });
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < exports.NUM_TESSERACT_WORKERS)) return [3 /*break*/, 6];
                        worker = tesseract_js_1.createWorker({
                            errorHandler: function (error) {
                                console.error('Encountered an error inside a Tesseract worker');
                                console.error(error);
                                _this.restartTesseract();
                            }
                        });
                        return [4 /*yield*/, worker.load()];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, worker.loadLanguage('eng')];
                    case 3:
                        _a.sent();
                        return [4 /*yield*/, worker.initialize('eng')];
                    case 4:
                        _a.sent();
                        this.scheduler.addWorker(worker);
                        _a.label = 5;
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6:
                        this.logEvent({
                            type: 'debug',
                            timestamp: new Date(),
                            msg: exports.NUM_TESSERACT_WORKERS + " Tesseract worker" + (exports.NUM_TESSERACT_WORKERS !== 1 ? 's' : '') + " I N I T I A L I Z E D"
                        });
                        this.tesseractInitialized = true;
                        return [2 /*return*/];
                }
            });
        });
    };
    HypetriggerManager.prototype.restartTesseract = function () {
        return __awaiter(this, void 0, void 0, function () {
            var promise;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.log('Restarting Tesseract...');
                        console.time('Tesseract restart');
                        this.tesseractInitialized = false;
                        return [4 /*yield*/, this.scheduler.terminate()];
                    case 1:
                        _a.sent();
                        this.scheduler = null;
                        return [4 /*yield*/, this.initTesseract()];
                    case 2:
                        promise = _a.sent();
                        console.timeEnd('Tesseract restart');
                        return [2 /*return*/, promise];
                }
            });
        });
    };
    HypetriggerManager.prototype.logEvent = function (event) {
        this.eventLog.push(event);
        this.eventListeners.forEach(function (callback) { return callback(event); });
        console.log(event.msg);
        // if (!this.eventLogRef || !this.eventLogRef.current) return
        // const eventLogElem = this.eventLogRef.current
        // eventLogElem.innerHTML += event.msg + '\n'
        // eventLogElem.scrollTo({
        //   top: eventLogElem.scrollHeight,
        //   behavior: 'smooth'
        // })
    };
    HypetriggerManager.prototype.onEvent = function (callback) {
        this.eventListeners.push(callback);
    };
    return HypetriggerManager;
}());
exports["default"] = HypetriggerManager;
//# sourceMappingURL=HypetriggerManager.js.map