"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var child_process_1 = require("child_process");
var fs_1 = require("fs");
var ini_1 = require("ini");
var obs_websocket_js_1 = __importDefault(require("obs-websocket-js"));
var path_1 = require("path");
var dataUriToBuffer_1 = __importDefault(require("./dataUriToBuffer"));
var isRunning_1 = __importDefault(require("./isRunning"));
var OBS_POSSIBLE_PATHS = [
    'C:\\Program Files\\obs-studio\\bin\\64bit\\obs64.exe',
    'C:\\Program Files (x86)\\obs-studio\\bin\\64bit\\obs64.exe',
    'C:\\Program Files (x86)\\obs-studio\\bin\\32bit\\obs32.exe',
    'C:\\Program Files\\obs-studio\\bin\\32bit\\obs32.exe',
];
var SETTINGS_FILENAME = "settings.json";
var OBS_LAUNCH_WAIT = 1000;
var OBS_LAUNCH_MAX_TRIES = 10;
var OBS_MIN_SCREENSHOT_DELAY = 500;
var OBS_MIN_VERSION = 27;
var OBSManager = /** @class */ (function () {
    function OBSManager() {
        this.connected = false;
        this.ws = new obs_websocket_js_1["default"]();
        this.screenshotPollingInterval = OBS_MIN_SCREENSHOT_DELAY;
        this.settings = {};
        this.screenshotNumber = 0;
        this.onError = function (error) {
            error.msg.split('\n').forEach(console.error);
            process.exit(1);
        };
    }
    OBSManager.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var e_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 9, , 10]);
                        return [4 /*yield*/, this.loadSettings()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.findOBS()];
                    case 2:
                        _a.sent();
                        return [4 /*yield*/, this.ensureWebsocketPluginInstalled()];
                    case 3:
                        _a.sent();
                        return [4 /*yield*/, this.checkOBSSettings()];
                    case 4:
                        _a.sent();
                        return [4 /*yield*/, this.ensureOBSRunning()];
                    case 5:
                        _a.sent();
                        return [4 /*yield*/, this.connectToWebsocket()];
                    case 6:
                        _a.sent();
                        return [4 /*yield*/, this.checkVersion()];
                    case 7:
                        _a.sent();
                        return [4 /*yield*/, this.ensureReplayBufferActive()];
                    case 8:
                        _a.sent();
                        return [3 /*break*/, 10];
                    case 9:
                        e_1 = _a.sent();
                        throw e_1; // rethrow
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.getSettingsPath = function () {
        return process.cwd() + "\\" + SETTINGS_FILENAME;
    };
    OBSManager.prototype.getOBSExe = function () {
        return this.settings.ObsPath;
    };
    OBSManager.prototype.getOBSRoot = function () {
        return path_1.resolve(this.settings.ObsPath, '../../../');
    };
    OBSManager.prototype.getOBSBasename = function () {
        return path_1.basename(this.settings.ObsPath);
    };
    OBSManager.prototype.getOBSWebsocketDLL = function () {
        return path_1.resolve(this.settings.ObsPath, '../../../obs-plugins/64bit/obs-websocket.dll');
    };
    OBSManager.prototype.getDependenciesRedist = function () {
        var path_debug = process.cwd() + "\\dependencies\\obs-websocket-4.9.1-Windows";
        var path_prod = process.cwd() + "\\resources\\app\\dependencies\\obs-websocket-4.9.1-Windows";
        if (fs_1.existsSync(path_debug))
            return path_debug;
        else if (fs_1.existsSync(path_prod))
            return path_prod;
        else
            throw new Error("OBS websocket plugin redistributable not found at " + path_debug + " or " + path_prod);
    };
    OBSManager.prototype.getOBSUserDataPath = function () {
        return process.env[(process.platform == 'win32') ? 'USERPROFILE' : 'HOME'] + "\\AppData\\Roaming\\obs-studio";
    };
    OBSManager.prototype.debugPaths = function () {
        console.group('Debugging file paths');
        console.log("getSettingsPath() => " + this.getSettingsPath());
        console.log("getOBSExe() => " + this.getOBSExe());
        console.log("getOBSRoot() => " + this.getOBSRoot());
        console.log("getOBSBasename() => " + this.getOBSBasename());
        console.log("getOBSWebsocketDLL() => " + this.getOBSWebsocketDLL());
        console.log("getDependenciesRedist() => " + this.getDependenciesRedist());
        console.groupEnd();
    };
    OBSManager.prototype.loadSettings = function () {
        return __awaiter(this, void 0, void 0, function () {
            var path, content;
            return __generator(this, function (_a) {
                path = this.getSettingsPath();
                try {
                    content = fs_1.readFileSync(path, 'utf8');
                    this.settings = JSON.parse(content);
                    console.log("Loaded app settings from " + path);
                }
                catch (e) {
                    console.log("No saved settings found at " + path);
                }
                return [2 /*return*/];
            });
        });
    };
    OBSManager.prototype.saveSettings = function () {
        return __awaiter(this, void 0, void 0, function () {
            var path, content;
            return __generator(this, function (_a) {
                path = this.getSettingsPath();
                content = JSON.stringify(this.settings, null, 2);
                fs_1.writeFileSync(path, content);
                console.log("Saved settings to " + path);
                return [2 /*return*/];
            });
        });
    };
    OBSManager.prototype.findOBS = function () {
        return __awaiter(this, void 0, void 0, function () {
            var paths, _i, paths_1, path, title;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        paths = [];
                        if (this.settings.ObsPath)
                            paths.push(this.settings.ObsPath);
                        paths.push.apply(paths, OBS_POSSIBLE_PATHS);
                        _i = 0, paths_1 = paths;
                        _a.label = 1;
                    case 1:
                        if (!(_i < paths_1.length)) return [3 /*break*/, 5];
                        path = paths_1[_i];
                        if (!fs_1.existsSync(path)) return [3 /*break*/, 4];
                        console.log("Found OBS executable at " + path);
                        if (!(this.settings.ObsPath !== path)) return [3 /*break*/, 3];
                        this.settings.ObsPath = path;
                        return [4 /*yield*/, this.saveSettings()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                    case 4:
                        _i++;
                        return [3 /*break*/, 1];
                    case 5: return [4 /*yield*/, this.saveSettings()];
                    case 6:
                        _a.sent();
                        title = "Couldn't find OBS";
                        this.onError({
                            title: title,
                            msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips. "
                                + ("No valid OBS installation could be found after checking " + paths.length + " typical default locations.</p>")
                                + ("<p>If OBS is already installed in a non-standard location (such as on another drive), please specify it in the settings file: <code>" + this.getSettingsPath() + "</code>.</p>")
                                + "<p>Otherwise, please install OBS from the official website: <a href=\"https://obsproject.com/\" target=\"blank\">https://obsproject.com/</a>.</p>"
                                + "<p>Afterwards, run this program again to continue.</p>"
                        });
                        throw new Error(title);
                }
            });
        });
    };
    OBSManager.prototype.checkWebsocketPluginInstalled = function () {
        return __awaiter(this, void 0, void 0, function () {
            var path, exists;
            return __generator(this, function (_a) {
                path = this.getOBSWebsocketDLL();
                exists = fs_1.existsSync(path);
                if (!exists)
                    console.error("OBS websocket plugin not found at " + path);
                return [2 /*return*/, exists];
            });
        });
    };
    OBSManager.prototype.closeOBS = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                // Should this prompt the user before exiting?
                child_process_1.execSync("taskkill /im " + this.getOBSBasename() + " /t /f /fi \"STATUS eq RUNNING\"");
                console.log('OBS closed');
                return [2 /*return*/];
            });
        });
    };
    OBSManager.prototype.ensureOBSClosed = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.OBSRunning()];
                    case 1:
                        if (!_a.sent()) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.closeOBS()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.installWebsocketPlugin = function () {
        return __awaiter(this, void 0, void 0, function () {
            var from, to;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        console.log("Installing OBS websocket plugin");
                        return [4 /*yield*/, this.ensureOBSClosed()];
                    case 1:
                        _a.sent();
                        from = "\"" + this.getDependenciesRedist() + "\"";
                        to = "\"" + this.getOBSRoot() + "\"";
                        console.log("Copying " + from + " to " + to);
                        child_process_1.execSync("start-process cmd -Wait -verb runas -argumentlist '/c Xcopy /E /I /Y " + from + " " + to + "'", { shell: 'powershell.exe' });
                        console.log("Successfully installed OBS websocket plugin");
                        return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.ensureWebsocketPluginInstalled = function () {
        return __awaiter(this, void 0, void 0, function () {
            var installed, title;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.checkWebsocketPluginInstalled()];
                    case 1:
                        installed = _a.sent();
                        if (!!installed) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.installWebsocketPlugin()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3: return [4 /*yield*/, this.checkWebsocketPluginInstalled()];
                    case 4:
                        installed = _a.sent();
                        if (!installed) {
                            title = "Couldn't install OBS plugin";
                            this.onError({
                                title: title,
                                msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips. "
                                    + "To do this, Clip It installs a plugin which allows it to communicate directly with OBS. "
                                    + "The plugin will start the OBS replay buffer, save clips at the right moment, and receive video frames for AI processing.</p>"
                                    + "<p>An automatic installation of the OBS plugin was attempted, but it didn't work. "
                                    + "The installation typically requires admin permissions \u2014 try re-running <code>clipit.exe</code> as administrator.</p>"
                                    + "<p>If plugin installation fails again, or if you're more comfortable installing the plugin manually, you can do so from the plugin's official Github: <a href=\"https://github.com/Palakis/obs-websocket\" target=\"blank\">https://github.com/Palakis/obs-websocket</a>.</p>"
                                    + "<p>Afterwards, run this program again to continue.</p>"
                            });
                            throw new Error(title);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.checkOBSSettings = function () {
        return __awaiter(this, void 0, void 0, function () {
            var settingsRoot, globalSettingsPath, globalSettings, profileDir, basicSettingsPath, basicSettings, basicSettingsChanged, settingsChanged;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        settingsRoot = this.getOBSUserDataPath();
                        globalSettingsPath = settingsRoot + "\\global.ini";
                        globalSettings = ini_1.parse(fs_1.readFileSync(globalSettingsPath, 'utf8'));
                        profileDir = globalSettings.Basic.ProfileDir;
                        console.log("Loaded global OBS settings from " + globalSettingsPath);
                        if (!!globalSettings.WebsocketAPI) return [3 /*break*/, 4];
                        globalSettings.WebsocketAPI = {
                            AuthSetupPrompted: true // skip the websocket setup prompt if we're installing the plugin automatically
                        };
                        return [4 /*yield*/, this.OBSRunning()];
                    case 1:
                        if (!_a.sent()) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.closeOBS()];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        fs_1.writeFileSync(globalSettingsPath, ini_1.stringify(globalSettings));
                        console.log("Wrote global OBS settings to " + globalSettingsPath);
                        _a.label = 4;
                    case 4:
                        basicSettingsPath = settingsRoot + "\\basic\\profiles\\" + profileDir + "\\basic.ini";
                        basicSettings = ini_1.parse(fs_1.readFileSync(basicSettingsPath, 'utf8'));
                        console.log("Loaded OBS profile basic settings from " + basicSettingsPath);
                        basicSettingsChanged = false;
                        if (!basicSettings.WebsocketAPI) {
                            basicSettings.WebsocketAPI = {
                                ServerEnabled: true,
                                ServerPort: 4444,
                                LockToIPv4: false,
                                DebugEnabled: false,
                                AlertsEnabled: false,
                                AuthRequired: false,
                                AuthSecret: "",
                                AuthSalt: ""
                            };
                            basicSettingsChanged = true;
                        }
                        // "Save Replay" hotkey must be set (even if it is only used programmatically)
                        if (!basicSettings.Hotkeys || !basicSettings.Hotkeys.ReplayBuffer) {
                            if (!basicSettings.Hotkeys)
                                basicSettings.Hotkeys = {};
                            basicSettings.Hotkeys.ReplayBuffer = "{\"ReplayBuffer.Save\":[{\"key\":\"OBS_KEY_DEAD_GRAVE\"}]}";
                            basicSettingsChanged = true;
                        }
                        // Enable replay buffer
                        if (!basicSettings.SimpleOutput.RecRB || basicSettings.SimpleOutput.RecRB === 'false') {
                            basicSettings.SimpleOutput.RecRB = 'true';
                            basicSettings.SimpleOutput.RecRBTime = 15;
                            basicSettings.SimpleOutput.RecRBSize = 1024;
                            basicSettingsChanged = true;
                        }
                        // Set duration of replay buffer
                        if (this.settings.ClipDuration && parseInt(basicSettings.SimpleOutput.RecRBTime) !== this.settings.ClipDuration) {
                            basicSettings.SimpleOutput.RecRBTime = this.settings.ClipDuration;
                            basicSettingsChanged = true;
                        }
                        else if (!this.settings.ClipDuration && basicSettings.SimpleOutput.RecRBTime) {
                            this.settings.ClipDuration = parseInt(basicSettings.SimpleOutput.RecRBTime);
                        }
                        if (!basicSettingsChanged) return [3 /*break*/, 8];
                        return [4 /*yield*/, this.OBSRunning()];
                    case 5:
                        if (!_a.sent()) return [3 /*break*/, 7];
                        return [4 /*yield*/, this.closeOBS()];
                    case 6:
                        _a.sent();
                        _a.label = 7;
                    case 7:
                        fs_1.writeFileSync(basicSettingsPath, ini_1.stringify(basicSettings));
                        console.log("Wrote basic OBS settings to " + basicSettingsPath);
                        _a.label = 8;
                    case 8:
                        settingsChanged = false;
                        if (this.settings.ObsWebsocketPort !== basicSettings.WebsocketAPI.ServerPort) {
                            this.settings.ObsWebsocketPort = basicSettings.WebsocketAPI.ServerPort;
                            settingsChanged = true;
                        }
                        if (this.settings.ClipDirectory !== basicSettings.SimpleOutput.FilePath) {
                            this.settings.ClipDirectory = basicSettings.SimpleOutput.FilePath;
                            settingsChanged = true;
                        }
                        if (!settingsChanged) return [3 /*break*/, 10];
                        return [4 /*yield*/, this.saveSettings()];
                    case 9:
                        _a.sent();
                        _a.label = 10;
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.OBSRunning = function () {
        return __awaiter(this, void 0, void 0, function () {
            var fileName, fileNameUnix;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        fileName = this.getOBSBasename();
                        fileNameUnix = fileName.split('.')[0];
                        return [4 /*yield*/, isRunning_1["default"](fileName, fileNameUnix, fileNameUnix)];
                    case 1: return [2 /*return*/, _a.sent()];
                }
            });
        });
    };
    OBSManager.prototype.ensureOBSRunning = function () {
        return __awaiter(this, void 0, void 0, function () {
            var running;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.OBSRunning()];
                    case 1:
                        running = _a.sent();
                        if (!running) {
                            this.startOBS();
                            return [2 /*return*/, new Promise(function (resolve) { return setTimeout(resolve, OBS_LAUNCH_WAIT); })];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.startOBS = function () {
        var path = this.getOBSExe();
        console.log("Launching OBS (" + path + ")");
        try {
            var lastSlash = path.lastIndexOf('\\');
            var cwd = path.substr(0, lastSlash);
            child_process_1.execFile(path, { cwd: cwd });
        }
        catch (e) {
            var title = "Couldn't start OBS";
            this.onError({
                title: title,
                msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips.</p>"
                    + ("<p>A valid OBS installation was found at <code>" + path + "</code>, but it failed to start.</p>")
                    + "<p>You can resolve this by confirming that the OBS executable at the specified path is valid, or you can start OBS manually yourself before opening Clip It.</p>"
                    + "<p>Afterwards, run this program again to continue.</p>"
            });
            throw new Error(title);
        }
    };
    OBSManager.prototype.connectToWebsocket = function (tryNum) {
        if (tryNum === void 0) { tryNum = 0; }
        return __awaiter(this, void 0, void 0, function () {
            var address, password, e_2, title;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        address = "localhost:" + this.settings.ObsWebsocketPort;
                        password = this.settings.ObsWebsocketPassword;
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 7]);
                        return [4 /*yield*/, this.ws.connect({ address: address, password: password })];
                    case 2:
                        _a.sent();
                        this.connected = true;
                        console.log("Connected to OBS via websocket on try #" + tryNum + " (address: " + address + ")");
                        return [3 /*break*/, 7];
                    case 3:
                        e_2 = _a.sent();
                        if (!(tryNum < OBS_LAUNCH_MAX_TRIES)) return [3 /*break*/, 6];
                        return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, OBS_LAUNCH_WAIT); })];
                    case 4:
                        _a.sent();
                        console.log("Retrying OBS websocket connection... (#" + (tryNum + 1) + ")");
                        return [4 /*yield*/, this.connectToWebsocket(tryNum + 1)];
                    case 5:
                        _a.sent();
                        return [2 /*return*/];
                    case 6:
                        title = "Failed to connect to OBS via websocket";
                        this.onError({
                            title: title,
                            msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips.</p>"
                                + ("<p>It does this by connecting to OBS via websocket. Connection failed when attempting to use address <code>" + address + "</code>.")
                                + (password ? " A custom password was specified in the config file and used at time of connection.</p>" : '</p>')
                                + ("<p>Compare the websocket settings in the Clip It settings file (<code>" + this.getSettingsPath() + "</code>) to the websocket settings inside OBS (by going to <code>Tools > WebSockets Server Settings</code>).</p>")
                                + "<p>Afterwards, run this program again to continue.</p>"
                        });
                        throw new Error(title);
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.checkVersion = function () {
        return __awaiter(this, void 0, void 0, function () {
            var response, obsVersion, majorVersion, title;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ws.send('GetVersion')];
                    case 1:
                        response = _a.sent();
                        obsVersion = response['obs-studio-version'];
                        majorVersion = parseInt(obsVersion.split('.')[0]);
                        console.log("OBS version " + obsVersion);
                        if (majorVersion < OBS_MIN_VERSION) {
                            title = "OBS out of date";
                            this.onError({
                                title: title,
                                msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips.</p>"
                                    + ("<p>Your current version of OBS (" + obsVersion + ") is out of date (requires >= " + OBS_MIN_VERSION + ".x).</p>")
                                    + "<p>Please update OBS to the latest version via the standard updater inside of OBS, or via the official website: <a href=\"https://obsproject.com/\" target=\"blank\">https://obsproject.com/</a>.</p>"
                                    + "<p>Afterwards, run this program again to continue.</p>"
                            });
                            throw new Error(title);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.ensureReplayBufferActive = function () {
        return __awaiter(this, void 0, void 0, function () {
            var isActive, e_3, title;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.ws.send('GetReplayBufferStatus')];
                    case 1:
                        isActive = (_a.sent()).isReplayBufferActive;
                        console.log("Replay buffer is currently " + (isActive ? 'on' : 'off'));
                        if (!!isActive) return [3 /*break*/, 5];
                        _a.label = 2;
                    case 2:
                        _a.trys.push([2, 4, , 5]);
                        return [4 /*yield*/, this.ws.send('StartReplayBuffer')];
                    case 3:
                        _a.sent();
                        console.log("Started replay buffer recording");
                        return [3 /*break*/, 5];
                    case 4:
                        e_3 = _a.sent();
                        title = "Could not start OBS replay buffer";
                        this.onError({
                            title: title,
                            msg: "<p>Clip It works side-by-side with OBS on your computer and uses it to record clips.</p>"
                                + "<p>The OBS replay buffer was unable to start. Double-check in the OBS settings that Replay Buffer is enabled (under <code>Settings > Output > Recording > Enable Replay Buffer</code>).</p>"
                                + "<p>Afterwards, run this program again to continue.</p>"
                        });
                        throw new Error(title);
                    case 5: return [2 /*return*/];
                }
            });
        });
    };
    OBSManager.prototype.getScreenshot = function (cb) {
        return __awaiter(this, void 0, void 0, function () {
            var start, _a, e_4, screenshot, elapsed, cpuUsage, delay;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        start = Date.now();
                        if (!this.connected) {
                            console.error("getScreenshot called, but websocket is not connected");
                            return [2 /*return*/];
                        }
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 3, , 4]);
                        _a = this;
                        return [4 /*yield*/, this.ws.send('GetStats')];
                    case 2:
                        _a.stats = (_b.sent()).stats;
                        if (cb)
                            cb(this.stats);
                        return [3 /*break*/, 4];
                    case 3:
                        e_4 = _b.sent();
                        console.error(e_4);
                        throw e_4;
                    case 4: return [4 /*yield*/, this.ws.send('TakeSourceScreenshot', { embedPictureFormat: 'png' })];
                    case 5:
                        screenshot = _b.sent();
                        this.screenshot = dataUriToBuffer_1["default"](screenshot.img);
                        elapsed = Date.now() - start;
                        if (elapsed > this.screenshotPollingInterval)
                            this.screenshotPollingInterval = elapsed + 100; // Always give at least a little breathing room so OBS doesn't freeze
                        else {
                            cpuUsage = this.stats['cpu-usage'];
                            if (cpuUsage > 90) {
                                this.screenshotPollingInterval += 100;
                                console.warn("CPU usage is " + Math.round(cpuUsage) + "% -- throttling polling interval up to " + this.screenshotPollingInterval + "ms");
                            }
                            else if (cpuUsage < 50 && this.screenshotPollingInterval > OBS_MIN_SCREENSHOT_DELAY) {
                                this.screenshotPollingInterval -= 100;
                                this.screenshotPollingInterval = Math.max(this.screenshotPollingInterval, OBS_MIN_SCREENSHOT_DELAY);
                                console.log("CPU usage is " + Math.round(cpuUsage) + "% -- decreasing polling interval down to " + this.screenshotPollingInterval + "ms");
                            }
                        }
                        delay = this.screenshotPollingInterval - elapsed;
                        this.nextScreenshotTime = Date.now() + delay;
                        this.screenshotNumber++;
                        this.screenshotTimeout = setTimeout(function () { return _this.getScreenshot(cb); }, delay);
                        return [2 /*return*/];
                }
            });
        });
    };
    return OBSManager;
}());
exports["default"] = OBSManager;
//# sourceMappingURL=OBSManager.js.map