"use strict";
/** @source https://stackoverflow.com/questions/38033127/node-js-how-to-check-a-process-is-running-by-the-process-name */
exports.__esModule = true;
var child_process_1 = require("child_process");
/**
 * Returns a promise that resolves to true if the current process is running
 */
function isRunning(win, mac, linux) {
    return new Promise(function (resolve, reject) {
        var plat = process.platform;
        var cmd = plat === 'win32' ? 'tasklist' : (plat === 'darwin' ? 'ps -ax | grep ' + mac : (plat === 'linux' ? 'ps -A' : ''));
        var proc = plat === 'win32' ? win : (plat === 'darwin' ? mac : (plat === 'linux' ? linux : ''));
        if (cmd === '' || proc === '')
            return resolve(false);
        child_process_1.exec(cmd, function (err, stdout, stderr) {
            resolve(stdout.toLowerCase().indexOf(proc.toLowerCase()) > -1);
        });
    });
}
exports["default"] = isRunning;
//# sourceMappingURL=isRunning.js.map