"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
exports.parserFromJson = exports.filterFromJson = void 0;
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var trigger_1 = __importDefault(require("../triggers/trigger"));
var CropFunction_1 = __importDefault(require("./CropFunction"));
function filterFromJson(json) {
    if (json.type === 'threshold')
        return new ThresholdFilter_1["default"](json);
    throw new Error("Unsupported filter type: " + json.type);
}
exports.filterFromJson = filterFromJson;
function parserFromJson(trigger, parser, manager) {
    if (parser.type === 'regex') {
        return function (text) {
            if (!text.match(parser.regex))
                return false;
            manager.logEvent({
                type: trigger.id,
                timestamp: new Date(),
                rawText: text,
                msg: "[" + trigger.id + "] EVENT => " + trigger.title
            });
            return true;
        };
    }
    throw new Error("Unsupported parser type: " + parser.type);
}
exports.parserFromJson = parserFromJson;
function triggerFromJson(json, manager) {
    return new trigger_1["default"]({
        manager: manager,
        title: json.title,
        id: json.id,
        enabled: json.enabled,
        cropFunction: new CropFunction_1["default"](json.crop),
        filters: json.filters.map(function (filter) { return filterFromJson(filter); }),
        parseFunction: parserFromJson(json, json.parser, manager),
        debug: json.debug
    });
}
exports["default"] = triggerFromJson;
//# sourceMappingURL=triggerFromJson.js.map