"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var trigger_1 = __importDefault(require("./trigger"));
var fuzzyset_1 = __importDefault(require("fuzzyset"));
var double_kill_fuzzyset = fuzzyset_1["default"](['DOUBLE KILL']);
/**
 * Targets a "Badge" text which sometimes appears along with a large
 * icon in the top middle.
 */
var BadgeTrigger = /** @class */ (function (_super) {
    __extends(BadgeTrigger, _super);
    function BadgeTrigger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.cropFunction = new CropFunction_1["default"]({
            y: (427 / 1440) * 100,
            yUnit: '%',
            yAnchor: 'top',
            x: (1122 / 2560) * 100,
            xUnit: '%',
            xAnchor: 'left',
            width: (342 / 2560) * 100,
            widthUnit: '%',
            height: (45 / 1440) * 100,
            heightUnit: '%'
        });
        _this.filters = [new ThresholdFilter_1["default"]({
                title: 'Threshold',
                r: 255,
                g: 255,
                b: 255,
                threshold: 15
            })];
        _this.parseFunction = function (text) {
            if (text.length <= 4)
                return false;
            if (!text.match(/^[A-Z\d\s]+$/))
                return false;
            _this.manager.logEvent({
                type: 'badge',
                rawText: text,
                parsed: text,
                msg: "[BadgeTrigger] " + text.trim(),
                timestamp: new Date()
            });
            return true;
        };
        _this.effects = ['notification'];
        return _this;
    }
    return BadgeTrigger;
}(trigger_1["default"]));
exports["default"] = BadgeTrigger;
//# sourceMappingURL=badge.js.map