"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var fuzzyset_1 = __importDefault(require("fuzzyset"));
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var trigger_1 = __importDefault(require("./trigger"));
var kills_fuzzyset = fuzzyset_1["default"](['KILL']);
/**
 * Targets the red box which contains the phrase "Nth KILL"
 * in the bottom middle of the screen. It displays for
 * approximately 2 seconds.
 *
 * The "N" in "Nth KILL" refers to number of kills this life,
 * (without dying), not the total number of kills (which shows
 * in the top-right in Warzone)
 */
var KillNotifTrigger = /** @class */ (function (_super) {
    __extends(KillNotifTrigger, _super);
    function KillNotifTrigger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * This crop is optimized for single-digit killcounts,
         * however it usually has *just* enough space to capture
         * 2-digit killcounts as well
         */
        _this.cropFunction = new CropFunction_1["default"]({
            y: (245 / 1440) * 100,
            yUnit: '%',
            yAnchor: 'bottom',
            x: 47.5,
            xUnit: '%',
            xAnchor: 'left',
            width: (98 / 1920) * 100,
            widthUnit: '%',
            height: (52 / 1440) * 100,
            heightUnit: '%'
        });
        _this.filters = [new ThresholdFilter_1["default"]({
                title: 'Threshold',
                r: 255,
                g: 0,
                b: 0,
                threshold: 42
            })];
        /**
         * Primarily looks for fuzzy text match for the word 'KILL'
         * The guaranteed-contrast red text against a transparent background
         * is pretty consistent to parse.
         *
         * Duplication is prevented by (naively) limiting kill events
         * to only ONE per two second period (the animation duration of the kill notif)
         */
        _this.parseFunction = function (text) {
            var parts = text.split(' ');
            if (parts.length !== 2)
                return false;
            var fuzzy = kills_fuzzyset.get(parts[1]);
            if (fuzzy && fuzzy[0] && fuzzy[0][0] && fuzzy[0][0] < 0.5)
                return false;
            _this.manager.parseHistory.push({
                type: 'kill-notif',
                rawText: text,
                timestamp: new Date()
            });
            var killEvent = _this.manager.eventLog.find(function (event) {
                return event.type === 'kill'
                    && new Date().getTime() - event.timestamp.getTime() < 2000;
            });
            if (killEvent)
                return false;
            _this.manager.logEvent({
                type: 'kill',
                timestamp: new Date(),
                rawText: text,
                msg: '[KillNotifTrigger] Player killed'
            });
            return true;
        };
        _this.effects = ['notification'];
        return _this;
    }
    return KillNotifTrigger;
}(trigger_1["default"]));
exports["default"] = KillNotifTrigger;
//# sourceMappingURL=kill-notif.js.map