"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
exports.__esModule = true;
var CropFunction_1 = __importDefault(require("../lib/CropFunction"));
var ThresholdFilter_1 = __importDefault(require("../filters/ThresholdFilter"));
var util_1 = require("../lib/util");
var trigger_1 = __importDefault(require("./trigger"));
/**
 * Targets the total number of kills displayed in
 * white text in the top right of the screen at almost
 * all times.
 */
var KillTotalTrigger = /** @class */ (function (_super) {
    __extends(KillTotalTrigger, _super);
    function KillTotalTrigger() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * This crop region unfortunately coincides with the
         * "number of players remaining in the airplane" number
         * during intial plane flight.
         *
         * That drawback is mitigated in the parsing function.
         */
        _this.cropFunction = new CropFunction_1["default"]({
            y: (60 / 1440) * 100,
            yUnit: '%',
            yAnchor: 'top',
            x: (2426 / 2560) * 100,
            xUnit: '%',
            xAnchor: 'left',
            width: (70 / 2560) * 100,
            widthUnit: '%',
            height: (40 / 1440) * 100,
            heightUnit: '%'
        });
        _this.filters = [new ThresholdFilter_1["default"]({
                title: 'Threshold',
                r: 255,
                g: 255,
                b: 255,
                threshold: 42
            })];
        /**
          * The contrast of this text is not great, so multiple frames
          * are compared in order to extract the correct number of total kills
          * with maximal confidence.
          */
        _this.parseFunction = function (text) {
            // Strict format
            var match = text.match(/^[\n\s]*\d{1,2}[\n\s]*$/);
            if (!match)
                return false;
            // Parse number
            var parsed = parseInt(text);
            if (!parsed)
                return false;
            _this.manager.parseHistory.push({
                type: 'kill-total',
                rawText: text,
                parsed: parsed,
                timestamp: new Date()
            });
            // Generate Event
            var killTotalResults = _this.manager.parseHistory.filter(function (result) { return result.type === 'kill-total'; });
            killTotalResults.reverse();
            killTotalResults = killTotalResults.slice(0, 5);
            if (killTotalResults.length < 2)
                return false; // Double check AT LEAST once the first time
            var numbers = killTotalResults.map(function (result) { return result.parsed; });
            // numbers is now an array of raw numbers (from the 5 most recent successful parses)
            var modes = util_1.mode(numbers); // find the consensus (the result gotten most often)
            if (modes.length !== 1)
                return false; // If there is a tie, it's not good enough
            var newKillTotal = modes[0];
            var killTotalEvents = _this.manager.eventLog.filter(function (event) { return event.type === 'kill-total'; });
            var lastKillTotal = killTotalEvents[killTotalEvents.length - 1];
            if (lastKillTotal && lastKillTotal.value === newKillTotal)
                return false; // We already announced this kill total
            var event = {
                timestamp: new Date(),
                type: 'kill-total',
                value: newKillTotal,
                msg: "[KillTotalTrigger] " + newKillTotal
            };
            _this.manager.logEvent(event);
            _this.handle10XBomb(event);
            return true;
        };
        /**
         * This trigger function handles "10X-BOMBS",
         * aka 10-bombs, 20-bombs, 30-bombs, etc.
         *
         * To help reduce unusual behavior, it also checks
         * that there has been a recent kill before dispatching the event.
         *
         * @TODO BUGFIX this will only work one time per session!
         */
        _this.handle10XBomb = function (event) {
            var _10bombEvent = _this.manager.eventLog.filter(function (event) { return event.type === '10-bomb'; })[0];
            var _20bombEvent = _this.manager.eventLog.filter(function (event) { return event.type === '20-bomb'; })[0];
            var _30bombEvent = _this.manager.eventLog.filter(function (event) { return event.type === '30-bomb'; })[0];
            var _40bombEvent = _this.manager.eventLog.filter(function (event) { return event.type === '40-bomb'; })[0];
            var recentKills = _this.manager.eventLog.filter(function (event) {
                return event.type === 'kill'
                    && new Date().getTime() - event.timestamp <= 5000;
            });
            if (recentKills.length === 0)
                return;
            if (!_40bombEvent && event.value >= 40) {
                _this.manager.logEvent({
                    timestamp: new Date(),
                    type: '40-bomb',
                    msg: '[KillTotalTrigger] 40-BOMB'
                });
                // this.manager.socket.emit('triggerEvent', {
                //   type: 'notification',
                //   msg: '40-BOMB'
                // })
            }
            else if (!_30bombEvent && event.value >= 30) {
                _this.manager.logEvent({
                    timestamp: new Date(),
                    type: '30-bomb',
                    msg: '[KillTotalTrigger] 30-BOMB'
                });
                // this.manager.socket.emit('triggerEvent', {
                //   type: 'notification',
                //   msg: '30-BOMB'
                // })
            }
            else if (!_20bombEvent && event.value >= 20) {
                _this.manager.logEvent({
                    timestamp: new Date(),
                    type: '20-bomb',
                    msg: '[KillTotalTrigger] 20-BOMB'
                });
                // this.manager.socket.emit('triggerEvent', {
                //   type: 'notification',
                //   msg: '20-BOMB'
                // })
            }
            else if (!_10bombEvent && event.value >= 10) {
                _this.manager.logEvent({
                    timestamp: new Date(),
                    type: '10-bomb',
                    msg: '[KillTotalTrigger] 10-BOMB'
                });
                // this.manager.socket.emit('triggerEvent', {
                //   type: 'notification',
                //   msg: '10-BOMB'
                // })
            }
        };
        _this.effects = ['notification', 'sound', 'something else'];
        return _this;
    }
    return KillTotalTrigger;
}(trigger_1["default"]));
exports["default"] = KillTotalTrigger;
//# sourceMappingURL=kill-total.js.map